ORCA/M Asm65816 2.1.0

0001 30C1                       title 'Control Manager Version 3.2' 
0002 30C1              **********************************************************************
0003 30C1              *
0004 30C1              *                   Control Manager version 3.2
0005 30C1              *
0006 30C1              *           Copyright Apple Computer, Inc. 1986-90
0007 30C1              *                    All rights reserved
0008 30C1              *                   Written by Dan Oliver
0009 30C1              *
0010 30C1              *                   Change History:
0011 30C1              *
0012 30C1              * 20-Nov-90         Dave Lyons
0013 30C1              *
0014 30C1              * Experimenting with making the background pattern for Scroll Bar
0015 30C1              * controls a solid gray, at least in 640 mode.
0016 30C1              * Version changed to $8303.
0017 30C1              * Fixed off-by-one bug in CMDieHorribly.  Wouldn't get the "="
0018 30C1              * character in "Error=xxxx".  Won't bother fixing for ROM 3.
0019 30C1              *
0020 30C1              * 20-Nov-90 (pm)    Dave Lyons
0021 30C1              *
0022 30C1              * Fixed the scroll bar color stuff (was failing to set B in one path).
0023 30C1              *
0024 30C1              * 9-Jan-91          Dave Lyons
0025 30C1              *
0026 30C1              * Changed HiliteControl(0,prevCtl) to use WaitUntil to wait 4 ticks
0027 30C1              * before unhiliting the control.
0028 30C1              *
0029 30C1              * 19-Jan-91         Dave Lyons
0030 30C1              *
0031 30C1              * Added 3 new calls:  FindRadioButton (returns info about which radio
0032 30C1              * button in a given family is selected); SetLETextByID and GetLETextByID,
0033 30C1              * setting and getting text in extended Edit Line controls (parameters
0034 30C1              * are window pointer, control ID and pString pointer).
0035 30C1              *
0036 30C1              * 22-Mar-91         Dave Lyons
0037 30C1              *
0038 30C1              * Added Compute320ScrollColor to search for a good Gray color to use
0039 30C1              * (called from NewResGuts).
0040 30C1              *
0041 30C1              * 8-Aug-91          Dave Lyons
0042 30C1              *
0043 30C1              * Get/SetLETextByID and FindRadioButton now accept window=NIL, to use
0044 30C1              * the front window.
0045 30C1              *
0046 30C1              * 15-Sep-91         Dave Lyons
0047 30C1              *
0048 30C1              * Changed CMLoadResource to force SysPrefs to always prompt for a
0049 30C1              * disk and never use a cancel button (because if we can't find
0050 30C1              * the resource, we're going to do a system death!).
0051 30C1              *
0052 30C1              * 4-Dec-91          Dave Lyons
0053 30C1              *
0054 30C1              * CMLoadResource now clears the supress-one-button-dialogs SysPrefs
0055 30C1              * bit, so the OS doesn't infinite-loop looking for the disk.
0056 30C1              *
0057 30C1              * 8-Dec-91          Dave Lyons
0058 30C1              *
0059 30C1              * Scroll bar--Compute320ScrollColor uses GetSCB instead of peeking
0060 30C1              * at SCB #100 directly.
0061 30C1              *
0062 30C1              * Split some large segments into some smaller PROCs for linking into
0063 30C1              * TS3.
0064 30C1              *
0065 30C1              * Changed LoadCodeResource to force OS preferences to prompt for a
0066 30C1              * disk, with no Cancel button.
0067 30C1              *
0068 30C1              * 9-Dec-91          Dave Lyons
0069 30C1              *
0070 30C1              * Changed Compute320ScrollColor to just ComputeScrollColor (it now
0071 30C1              * checks the MasterSCB itself).  CtlNewRes calls ComputeScrollColor.
0072 30C1              *
0073 30C1              * 15-Jan-92         Dave Lyons
0074 30C1              *
0075 30C1              * Having CtlNewRes call RefreshDesktop was a truly boneheaded move,
0076 30C1              * because really strange and not-goot reentrant things happen.
0077 30C1              * Instead when ComputeScrollColor changes the scroll-bar page-area
0078 30C1              * pattern/color, it uses AddToRunQ to add refreshDeskTask, which
0079 30C1              * calls RefreshDesktop(0) and removes itself from the queue.
0080 30C1              * This way we refresh the desktop on the next SystemTask call.
0081 30C1              *
0082 30C1              * 15-Jan-92pm       Dave Lyons
0083 30C1              *
0084 30C1              * Made CtlShutDown remove the Run Queue task, in case it got left
0085 30C1              * hanging.
0086 30C1              *
0087 30C1              * 5-Feb-92          Dave Lyons
0088 30C1              *
0089 30C1              * Changed version to $0303 for 6.0.
0090 30C1              *
0091 30C1              **********************************************************************
0092 30C1              *
0093 30C1              * 3-Jun-92          Dave Lyons
0094 30C1              *
0095 30C1              * Changed version to $8304 for 6.0.1d5.
0096 30C1              *
0097 30C1              * Made CtlStartUp remove the RefreshDesktop run queue routine, to
0098 30C1              * avoid redrawing everything once when starting an application in
0099 30C1              * a different resolution.
0100 30C1              *
0101 30C1              * 15-Jul-92         Dave Lyons (6.0.1d7)
0102 30C1              *
0103 30C1              * Added new calls:
0104 30C1              *   $3C10 SetCtlValueByID(Value,@Wind,CtlID/4)
0105 30C1              *   $3D10 GetCtlValueByID(@Wind,CtlID/4):Value
0106 30C1              *   $3E10 InvalOneCtlByID(@Wind,CtlID/4)
0107 30C1              *   $3F10 HiliteCtlByID(Hilite,@Wind,CtlID/4)
0108 30C1              *
0109 30C1              * 22-Mar-93         Dave Lyons (6.0.1d15)
0110 30C1              *
0111 30C1              * Changed GetAndSetPrefs and SetPrefsToA to use DoSysPrefs instead
0112 30C1              * of making GS/OS calls.  This speeds up every call to CMLoadResource.
0113 30C1              *
0114 30C1              * 1-Apr-93          Steve Stephenson
0115 30C1              *
0116 30C1              * Changed version to $0304 for 6.0.1 (final)
0117 30C1              *
0118 30C1              **********************************************************************
0119 30C1
0120 30C1
0121 30C1              ;====================================================================
0122 30C1              ;
0123 30C1              ;                   CtlShutDown
0124 30C1              ;
0125 30C1              ;                   Application's call for shutting down the Control Manager.
0126 30C1              ;
0127 30C1              ;   IN:    None.
0128 30C1              ;
0129 30C1              ;  OUT:    None.
0130 30C1              ;====================================================================
0131 30C1              CtlShutDown PROC export 
0132 30C1              *** added 15-Jan-92 DAL -- remove my RunQueue task
0133 30C1                       import refreshDeskTask 
0134 30C1 F4 02 00 F4           pushlong #refreshDeskTask 
0135 30C7 A2 05 20 22           _RemoveFromRunQ 
0136 30CE              *** end 15-Jan-92
0137 30CE              ;
0138 30CE              ; Real shut down in CtlReset call.
0139 30CE              ;
0140 30CE A9 00 00              lda   #0                       No error code.
0141 30D1 18                    clc                            No error flag.
0142 30D2 6B                    rtl                            Do nothing, Window Manager will shutdown.
0143 30D3
0144 30D3                       ENDP 
0145 30D3
0146 30D3
0147 30D3              **********************************************************************
0148 30D3              *
0149 30D3              * $3910 FindRadioButton -- added 19-Jan-91 DAL
0150 30D3              *
0151 30D3              * This routine is compatible with the fmdWhichRadio call in the
0152 30D3              * DTS FakeModalDialog user toolset (original code by Eric Soldan).
0153 30D3              *
0154 30D3              * Inputs:
0155 30D3              *   Space for result (WORD)
0156 30D3              *   Window Pointer   (LONG)
0157 30D3              *   Family Number    (WORD)
0158 30D3              *
0159 30D3              * Given the family number of a family of extended radio button controls
0160 30D3              * in the specified window, we determine which radio button in the family
0161 30D3              * is selected, and the return value is the selected button's control ID
0162 30D3              * MINUS the control ID of the lowest-ID'ed control in the family.
0163 30D3              *
0164 30D3              **********************************************************************
0165 30D3              FindRadioButton proc export 
0166 30D3
0167 30D3              ; offset constants for CtlRec
0168 30D3              octlNext equ   0
0169 30D3              octlOwner equ   4
0170 30D3              octlRect equ   8
0171 30D3              octlFlag equ   16
0172 30D3              octlHilite equ   17
0173 30D3              octlValue equ   18
0174 30D3              octlProc equ   20
0175 30D3              octlAction equ   24
0176 30D3              octlData equ   28
0177 30D3              octlRefCon equ   32
0178 30D3              octlColor equ   36
0179 30D3              octlReserved equ   40
0180 30D3              octlID   equ   56
0181 30D3              octlMoreFlags equ   60
0182 30D3              octlVersion equ   62
0183 30D3
0184 30D3                       DefineStack 
0185 30D3
0186 30D3              ctlHndl  long                           ;Must be at 1,s
0187 30D3              rbCtlPtr long 
0188 30D3              ctlID    long                           ;ID of some radio button control.
0189 30D3              theRadBut word 
0190 30D3              notHere  word                           ;Flag for active button not found.
0191 30D3
0192 30D3              sizeLocals EndLocals 
0193 30D3
0194 30D3              saveDPage word 
0195 30D3              returnAddr block 6                      ;was block 3 (DAL)
0196 30D3
0197 30D3                       BegParms 
0198 30D3              famNum   word 
0199 30D3              wptr     long                           ;Window that owns the control.
0200 30D3              sizeParms EndParms 
0201 30D3
0202 30D3              radioNum word 
0203 30D3
0204 30D3 0B                    phd                            ;Save directPage register.
0205 30D4 3B                    tsc                            ;Make space for locals.
0206 30D5 38                    sec   
0207 30D6 E9 10 00              sbc   #sizeLocals
0208 30D9 1B                    tcs   
0209 30DA 5B                    tcd                            ;Set directPage register.
0210 30DB
0211 30DB A9 FF FF              lda   #$FFFF                   ;This is supposed to be a bogus value
0212 30DE 85 1F                 sta   radioNum                 ;(0 is legit).
0213 30E0 85 0F                 sta   notHere                  ;Assume we won't find active radio
0214 30E2 85 0B                 sta   ctlID+2                  ;button of correct family number.
0215 30E4
0216 30E4              *** added 8-Aug-91 DAL, to handle window-pointer = NIL --> front window
0217 30E4 A5 1C                 lda   <wptr+1
0218 30E6 D0 0F                 bne   @notNIL
0219 30E8 48                    pha   
0220 30E9 48                    pha   
0221 30EA A2 0E 15 22           _FrontWindow 
0222 30F1 68                    pla   
0223 30F2 85 1B                 sta   <wptr
0224 30F4 68                    pla   
0225 30F5 85 1D                 sta   <wptr+2
0226 30F7              @notNIL   
0227 30F7              *** end 8-Aug-91 DAL
0228 30F7
0229 30F7 D4 1D                 pei   wptr+2
0230 30F9 D4 1B                 pei   wptr
0231 30FB A2 0E 33 22           _GetWControls                  ;Result space already there (ctlHndl).
0232 3102 B0 5C                 bcs   @exit
0233 3104
0234 3104 A5 02        @loop    lda   ctlHndl+1                ;See if we have a NULL handle yet.
0235 3106 F0 4A                 beq   @endLoop
0236 3108
0237 3108 20 6F 34              jsr   @derefCtl                ;Deref ctlHndl into rbCtlPtr.
0238 310B
0239 310B A0 16 00              ldy   #octlProc+2              ;Get hi-word of proc address.
0240 310E B7 05                 lda   [rbCtlPtr],y
0241 3110 C9 00 84              cmp   #radioControl>>16
0242 3113 D0 30                 bne   @nextCtl                 ;Not a radio button.  Skip it.
0243 3115
0244 3115 A0 10 00              ldy   #octlFlag
0245 3118 B7 05                 lda   [rbCtlPtr],y
0246 311A 29 7F 00              and   #$7F
0247 311D C5 19                 cmp   famNum                   ;See if it is "our" family.
0248 311F D0 24                 bne   @nextCtl                 ;Not related.
0249 3121
0250 3121 A0 3A 00              ldy   #octlID+2                ;See if this is the smallest ctlID for
0251 3124 B7 05                 lda   [rbCtlPtr],y             ;our family yet.
0252 3126 AA                    tax   
0253 3127 88                    dey   
0254 3128 88                    dey   
0255 3129 B7 05                 lda   [rbCtlPtr],y
0256 312B E4 0B                 cpx   ctlID+2
0257 312D 90 06                 bcc   @smaller
0258 312F D0 08                 bne   @a                       ;It isn't.
0259 3131 C5 09                 cmp   ctlID
0260 3133 B0 04                 bcs   @a                       ;It isn't.
0261 3135 85 09        @smaller sta   ctlID                    ;It is, so remember it.
0262 3137 86 0B                 stx   ctlID+2
0263 3139
0264 3139 AA           @a       tax   
0265 313A A0 12 00              ldy   #octlValue
0266 313D B7 05                 lda   [rbCtlPtr],y
0267 313F F0 04                 beq   @nextCtl                 ;This isn't the active radio button.
0268 3141 86 0D                 stx   theRadBut                ;This is the one, so remember enough
0269 3143 64 0F                 stz   notHere                  ;of it.  Also, flag we found it.
0270 3145
0271 3145 A0 02 00     @nextCtl ldy   #2
0272 3148 A7 05                 lda   [rbCtlPtr]
0273 314A 85 01                 sta   ctlHndl
0274 314C B7 05                 lda   [rbCtlPtr],y
0275 314E 85 03                 sta   ctlHndl+2
0276 3150 80 B2                 bra   @loop
0277 3152
0278 3152 A5 0F        @endLoop lda   notHere                  ;See if we found it.  If we didn't,
0279 3154 30 05                 bmi   @b                       ;return $FFFF to indicate this.
0280 3156 A5 0D                 lda   theRadBut
0281 3158 38                    sec   
0282 3159 E5 09                 sbc   ctlID
0283 315B 85 1F        @b       sta   radioNum                 ;This is what the programmer was
0284 315D                                                      ;yearning for.
0285 315D
0286 315D A9 00 00              lda   #0                       ;Return no error.
0287 3160 AA           @exit    tax                            ;save error code in X
0288 3161
0289 3161 7B                    tdc                            ;Get rid of local variables.
0290 3162 18                    clc   
0291 3163 69 10 00              adc   #sizeLocals
0292 3166 1B                    tcs   
0293 3167 2B                    pld                            ;Restore directPage register.
0294 3168 A0 06 00              ldy   #sizeParms               ;error already in X
0295 316B 5C 84 01 E1           jml   $e10184                  ;ToStrip
0296 316F
0297 316F A0 02 00     @derefCtl ldy   #2
0298 3172 A7 01                 lda   [ctlHndl]
0299 3174 85 05                 sta   rbCtlPtr
0300 3176 B7 01                 lda   [ctlHndl],y
0301 3178 85 07                 sta   rbCtlPtr+2
0302 317A 60                    rts   
0303 317B
0304 317B                       ENDP 
0305 317B
0306 317B
0307 317B              **********************************************************************
0308 317B              *
0309 317B              * $3A10 SetLETextByID -- added 19-Jan-91 DAL
0310 317B              *
0311 317B              * This routine is compatible with the fmdLESetText call in the
0312 317B              * DTS FakeModalDialog user toolset (original code by Eric Soldan).
0313 317B              *
0314 317B              * Inputs:
0315 317B              *   Window Pointer        (LONG)
0316 317B              *   Edit Line Control ID  (LONG)
0317 317B              *   Pascal String Pointer (LONG)
0318 317B              *
0319 317B              * Given the control ID of an extended edit line control in the
0320 317B              * specified window, we set its text from the Pascal string, thus
0321 317B              * saving the application programmer having to call GetCtlHandleFromID,
0322 317B              * GetCtlTitle, and LESetText, plus some miscellaneous string
0323 317B              * manipulation and handle dereferencing.
0324 317B              *
0325 317B              * This routine *selects* the text it puts into the Edit Line control.
0326 317B              *
0327 317B              **********************************************************************
0328 317B              SetLETextByID proc export 
0329 317B                       export GetLETextByID 
0330 317B
0331 317B              ; offset constants for LERec
0332 317B              oleLineHandle equ   0
0333 317B              oleLength equ   4
0334 317B              oleMaxLength equ   6
0335 317B              oleDestRect equ   8
0336 317B              oleViewRect equ   16
0337 317B              olePort  equ   24
0338 317B              oleLineHite equ   28
0339 317B              oleBaseHite equ   30
0340 317B              oleSelStart equ   32
0341 317B              oleSelEnd equ   34
0342 317B              oleActFlg equ   36
0343 317B              oleCarAct equ   38
0344 317B              oleCarOn equ   40
0345 317B              oleCarTime equ   42
0346 317B              oleHiliteHook equ   46
0347 317B              oleCaretHook equ   50
0348 317B              oleJust  equ   54
0349 317B              olePWChar equ   56
0350 317B              ; from E16.Control
0351 317B              octlData equ   28
0352 317B
0353 317B                       DefineStack 
0354 317B
0355 317B              ctlHndl  long 
0356 317B              leCtlPtr long 
0357 317B              leHndl   long 
0358 317B              lePtr    long 
0359 317B              lineHndl long 
0360 317B              linePtr  long 
0361 317B              cstr     long 
0362 317B              lineLength word 
0363 317B              leRect   block 8                        ;Must be > oleViewRect ($10)
0364 317B
0365 317B              sizeLocals EndLocals 
0366 317B
0367 317B              saveDPage word 
0368 317B              returnAddr block 6                      ;was block 3 (DAL)
0369 317B
0370 317B                       BegParms 
0371 317B              pstr     long                           ;Pointer to string space.
0372 317B              lineEditID long                         ;ID of lineEdit control.
0373 317B              wptr     long                           ;Window that owns the control.
0374 317B              sizeParms EndParms 
0375 317B
0376 317B              *
0377 317B              * SetLETextByID
0378 317B              *
0379 317B 20 1C 35              jsr   lineEditSetup            ;Set up everything we need.
0380 317E B0 65                 bcs   exit                     ;Couldn't dereference for some reason.
0381 3180
0382 3180 D4 1B                 pei   cstr+2                   ;Set text to c-string.
0383 3182 D4 19                 pei   cstr
0384 3184 A7 2F                 lda   [pstr]                   ;Get length of pascal string.
0385 3186 29 FF 00              and   #$00FF
0386 3189 48                    pha   
0387 318A D4 0B                 pei   leHndl+2
0388 318C D4 09                 pei   leHndl
0389 318E A2 14 0B 22           _LESetText 
0390 3195 B0 4E                 bcs   exit
0391 3197
0392 3197 48                    pha                            ;Invalidate view rect of lineEdit.
0393 3198 48                    pha   
0394 3199 A2 04 1C 22           _GetPort                       ;Save the current port.
0395 31A0 D4 39                 pei   wptr+2
0396 31A2 D4 37                 pei   wptr
0397 31A4 A2 04 1B 22           _SetPort                       ;Make the window the current port
0398 31AB                                                      ;(for _InvalRect).
0399 31AB
0400 31AB 20 76 35              jsr   lineEditDeref            ;Redereference -- slow but small.
0401 31AE A0 20 00              ldy   #oleSelStart
0402 31B1 A9 00 00              lda   #0
0403 31B4 48                    pha                            ;Hi-word for _InvalRect.
0404 31B5 97 0D                 sta   [lePtr],y
0405 31B7 C8                    iny   
0406 31B8 C8                    iny                            ;Point at leSelEnd.
0407 31B9 A7 2F                 lda   [pstr]                   ;Get length of pascal string.
0408 31BB 29 FF 00              and   #$00FF
0409 31BE 97 0D                 sta   [lePtr],y
0410 31C0
0411 31C0 A0 16 00              ldy   #oleViewRect+6           ;Copy lineEdit viewRect into rect.
0412 31C3 B7 0D        @a       lda   [lePtr],y
0413 31C5 BB                    tyx   
0414 31C6 95 0F                 sta   <leRect-oleViewRect,x
0415 31C8 88                    dey   
0416 31C9 88                    dey   
0417 31CA C0 10 00              cpy   #oleViewRect
0418 31CD B0 F4                 bcs   @a
0419 31CF
0420 31CF 7B                    tdc                            ;Hi-word alreay on stack.  (It's a 0).
0421 31D0 69 1F 00              adc   #leRect                  ;Carry still clear.
0422 31D3 48                    pha   
0423 31D4 A2 0E 3A 22           _InvalRect                     ;Inval that rect.
0424 31DB
0425 31DB A2 04 1B 22           _SetPort                       ;Put the port back.
0426 31E2
0427 31E2 A9 00 00     exitNoErr lda   #0                      ;Return no error.
0428 31E5 AA           exit     tax                            ;Save error code.
0429 31E6
0430 31E6 7B                    tdc                            ;Get rid of local variables.
0431 31E7 18                    clc   
0432 31E8 69 26 00              adc   #sizeLocals
0433 31EB 1B                    tcs   
0434 31EC 2B                    pld                            ;Restore directPage register.
0435 31ED
0436 31ED A0 0C 00              ldy   #sizeParms
0437 31F0 5C 84 01 E1           jml   $e10184                  ;ToStrip
0438 31F4
0439 31F4
0440 31F4
0441 31F4              **********************************************************************
0442 31F4              *
0443 31F4              * $3B10 GetLETextByID -- added 19-Jan-91 DAL
0444 31F4              *
0445 31F4              * This routine is compatible with the fmdLESetText call in the
0446 31F4              * DTS FakeModalDialog user toolset (original code by Eric Soldan).
0447 31F4              *
0448 31F4              * Inputs:
0449 31F4              *   Window Pointer        (LONG)
0450 31F4              *   Edit Line Control ID  (LONG)
0451 31F4              *   Pascal String Pointer (LONG)
0452 31F4              *
0453 31F4              * Given the control ID of an extended edit line control in the
0454 31F4              * specified window, we fetch its text into the Pascal string, thus
0455 31F4              * saving the application programmer having to call GetCtlHandleFromID,
0456 31F4              * GetCtlTitle, LEGetTextHand, LEGetTextLen, and doing miscellaneous
0457 31F4              * string manipulation and handle dereferencing.
0458 31F4              *
0459 31F4              **********************************************************************
0460 31F4              GetLETextByID  
0461 31F4 20 1C 35              jsr   lineEditSetup            ;Set up everything we need.
0462 31F7 B0 EC                 bcs   exit                     ;Couldn't dereference for some reason.
0463 31F9
0464 31F9 D4 17                 pei   linePtr+2                ;Copy the text into the string.
0465 31FB D4 15                 pei   linePtr
0466 31FD D4 1B                 pei   cstr+2
0467 31FF D4 19                 pei   cstr
0468 3201 F4 00 00              pea   0
0469 3204 D4 1D                 pei   lineLength
0470 3206 A2 02 2B 22           _BlockMove 
0471 320D
0472 320D A4 1D                 ldy   lineLength               ;Store the p-string length and also
0473 320F 98                    tya                            ;terminate the string for the c dudes.
0474 3210 E2 20                 shortm                         ;Use 8-bit accumulator.
0475 3212 87 2F                 sta   [pstr]                   ;Save the p-string length byte.
0476 3214 A9 00                 lda   #0
0477 3216 97 19                 sta   [cstr],y                 ;Terminate the c-string.
0478 3218 C2 20                 longm                          ;Set accumulator back to 16-bit.
0479 321A
0480 321A 80 C6                 bra   exitNoErr                ;Return no error.
0481 321C
0482 321C              *** Subroutines common to SetLETextByID and GetLETextByID
0483 321C
0484 321C              *
0485 321C              * lineEditSetup -- set up the stack frame, get the control handle from
0486 321C              * its ID, deref control handle into leCtlPtr, get the line edit handle
0487 321C              * from the ctlData field, and set lineHndl and linePtr to the text.
0488 321C              *
0489 321C FA           lineEditSetup plx                       ;Save return address so stack frame
0490 321D                                                      ;setup works.
0491 321D
0492 321D 0B                    phd                            ;Save directPage register.
0493 321E 3B                    tsc                            ;Make space for locals.
0494 321F 38                    sec   
0495 3220 E9 26 00              sbc   #sizeLocals
0496 3223 1B                    tcs   
0497 3224 5B                    tcd                            ;Set directPage register.
0498 3225
0499 3225 DA                    phx                            ;Put return address back.
0500 3226
0501 3226 A5 2F                 lda   pstr                     ;Also point past p-string length
0502 3228 A6 31                 ldx   pstr+2                   ;for c-strings.
0503 322A 1A                    inc   a
0504 322B D0 01                 bne   @a
0505 322D E8                    inx   
0506 322E 85 19        @a       sta   cstr
0507 3230 86 1B                 stx   cstr+2
0508 3232
0509 3232              *** added 8-Aug-91 DAL, to handle window-pointer = NIL --> front window
0510 3232 A5 38                 lda   <wptr+1
0511 3234 D0 0F                 bne   @notNIL
0512 3236 48                    pha   
0513 3237 48                    pha   
0514 3238 A2 0E 15 22           _FrontWindow 
0515 323F 68                    pla   
0516 3240 85 37                 sta   <wptr
0517 3242 68                    pla   
0518 3243 85 39                 sta   <wptr+2
0519 3245              @notNIL   
0520 3245              *** end 8-Aug-91 DAL
0521 3245
0522 3245 48                    pha                            ;Get the control handle via wptr,id.
0523 3246 48                    pha   
0524 3247 D4 39                 pei   wptr+2
0525 3249 D4 37                 pei   wptr
0526 324B D4 35                 pei   lineEditID+2
0527 324D D4 33                 pei   lineEditID
0528 324F A2 10 30 22           _GetCtlHandleFromID 
0529 3256 FA                    plx   
0530 3257 86 01                 stx   ctlHndl
0531 3259 FA                    plx   
0532 325A 86 03                 stx   ctlHndl+2
0533 325C B0 43                 bcs   rts1
0534 325E
0535 325E A0 02 00              ldy   #2                       ;Dereference ctlHndl.
0536 3261 A7 01                 lda   [ctlHndl]
0537 3263 85 05                 sta   leCtlPtr
0538 3265 B7 01                 lda   [ctlHndl],y
0539 3267 85 07                 sta   leCtlPtr+2
0540 3269
0541 3269 A0 1C 00              ldy   #octlData                ;Get the lineEdit handle from
0542 326C B7 05                 lda   [leCtlPtr],y             ;the control's data field.
0543 326E 85 09                 sta   leHndl
0544 3270 C8                    iny   
0545 3271 C8                    iny   
0546 3272 B7 05                 lda   [leCtlPtr],y
0547 3274 85 0B                 sta   leHndl+2
0548 3276              * fall into lineEditDeref
0549 3276
0550 3276 A0 02 00     lineEditDeref ldy   #2                  ;Dereference leHndl.
0551 3279 A7 09                 lda   [leHndl]
0552 327B 85 0D                 sta   lePtr
0553 327D B7 09                 lda   [leHndl],y
0554 327F 85 0F                 sta   lePtr+2
0555 3281
0556 3281 A0 04 00              ldy   #oleLength
0557 3284 B7 0D                 lda   [lePtr],y
0558 3286 85 1D                 sta   lineLength
0559 3288
0560 3288 A0 00 00              ldy   #oleLineHandle
0561 328B B7 0D                 lda   [lePtr],y
0562 328D 85 11                 sta   lineHndl
0563 328F C8                    iny   
0564 3290 C8                    iny   
0565 3291 B7 0D                 lda   [lePtr],y
0566 3293 85 13                 sta   lineHndl+2
0567 3295
0568 3295 A0 02 00              ldy   #2                       ;Dereference lineHndl.
0569 3298 A7 11                 lda   [lineHndl]
0570 329A 85 15                 sta   linePtr
0571 329C B7 11                 lda   [lineHndl],y
0572 329E 85 17                 sta   linePtr+2
0573 32A0 18                    clc                            ;Everything worked.
0574 32A1
0575 32A1 60           rts1     rts   
0576 32A2
0577 32A2                       EndP 
0578 32A2
0579 32A2
0580 32A2              **********************************************************************
0581 32A2              *
0582 32A2              CMLoadResource PROC EXPORT 
0583 32A2              *
0584 32A2              * This is an external entry to the LoadResource call below.
0585 32A2              *
0586 32A2              * Inputs:
0587 32A2              *                   HandleSpace : LONG
0588 32A2              *                   Type        : WORD
0589 32A2              *                   ID          : ID
0590 32A2              *
0591 32A2              * Outputs:
0592 32A2              *                   ResourceHandle
0593 32A2              *
0594 32A2              *
0595 32A2              **********************************************************************
0596 32A2                       DefineStack 
0597 32A2              OrigD    word 
0598 32A2              RTL1     block 3 
0599 32A2              RTL2     block 3 
0600 32A2              TheID    long 
0601 32A2              TheType  word 
0602 32A2              TheHandle word 
0603 32A2
0604 32A2                       import GetAndSetPrefs 
0605 32A2
0606 32A2 0B                    phd   
0607 32A3 3B                    tsc   
0608 32A4 5B                    tcd   
0609 32A5
0610 32A5              *** added 15-Sep-91 DAL
0611 32A5 20 C9 35              jsr   GetAndSetPrefs
0612 32A8 48                    pha   
0613 32A9              *** end 15-Sep-91
0614 32A9
0615 32A9 48                    pha   
0616 32AA 48                    pha   
0617 32AB D4 0D                 pei   TheType
0618 32AD D4 0B                 pei   TheID+2
0619 32AF D4 09                 pei   TheID
0620 32B1 20 E7 35              jsr   LoadResource
0621 32B4
0622 32B4 68                    pla   
0623 32B5 85 0F                 sta   TheHandle
0624 32B7 68                    pla   
0625 32B8 85 11                 sta   TheHandle+2
0626 32BA
0627 32BA              *** added 15-Sep-91 DAL
0628 32BA 68                    pla   
0629 32BB 20 D9 35              jsr   SetPrefsToA
0630 32BE              *** end 15-Sep-91
0631 32BE
0632 32BE 2B                    pld   
0633 32BF A2 00 00              ldx   #0
0634 32C2 A0 06 00              ldy   #6
0635 32C5 5C 84 01 E1           jml   ToStrip
0636 32C9
0637 32C9                       EndP 
0638 32C9
0639 32C9              ;GetAndSetPrefs	proc export
0640 32C9              ;	pea	$0000	;space for old prefs
0641 32C9              ;	pea	$0001	;pcount
0642 32C9              ;	tsc
0643 32C9              ;	inc	a
0644 32C9              ;	pea	0
0645 32C9              ;	pha
0646 32C9              ;	pea	$200F	;GetSysPrefs
0647 32C9              ;	jsl	$e100b0
0648 32C9              ;
0649 32C9              ;	lda	3,s	;old prefs
0650 32C9              ;	ora	#$C000	;force vol-mount w/ no cancel
0651 32C9              ;	and	#$DFFF	;don't supress the dialog! (4-Dec-91 DAL)
0652 32C9              ;	jsr	SetPrefsToA
0653 32C9              ;
0654 32C9              ;	pla
0655 32C9              ;	pla	;A=old prefs value
0656 32C9              ;	rts
0657 32C9              ;
0658 32C9              ;	export SetPrefsToA
0659 32C9              ;SetPrefsToA	pha	;new prefs value
0660 32C9              ;	pea	$0001	;pcount
0661 32C9              ;	tsc
0662 32C9              ;	inc	a
0663 32C9              ;	pea	0
0664 32C9              ;	pha
0665 32C9              ;	pea	$200C	;SetSysPrefs
0666 32C9              ;	jsl	$e100b0
0667 32C9              ;	pla
0668 32C9              ;	pla
0669 32C9              ;	rts
0670 32C9
0671 32C9              *** changed 22-Mar-93 DAL
0672 32C9              GetAndSetPrefs proc export 
0673 32C9 48                    pha                            ;space for result
0674 32CA F4 00 20              pea   $2000                    ;bits to clear (don't suppress dialog)
0675 32CD F4 00 C0              pea   $C000                    ;bits to set (force vol-mount, no cancel)
0676 32D0              ;	_DoSysPrefs
0677 32D0 A2 03 3F              ldx   #$3f03
0678 32D3 22 00 00 E1           jsl   $e10000
0679 32D7 68                    pla                            ;old preferences
0680 32D8 60                    rts   
0681 32D9
0682 32D9                       export SetPrefsToA 
0683 32D9 48           SetPrefsToA pha                         ;space for result
0684 32DA F4 FF FF              pea   $FFFF                    ;bits to clear (all)
0685 32DD 48                    pha                            ;bits to set (input)
0686 32DE              ;	_DoSysPrefs
0687 32DE A2 03 3F              ldx   #$3f03
0688 32E1 22 00 00 E1           jsl   $e10000
0689 32E5 68                    pla                            ;discard result
0690 32E6 60                    rts   
0691 32E7              *** end 22-Mar-93
0692 32E7
0693 32E7                       ENDP 
0694 32E7
0695 32E7
0696 32E7              ****************************************************************
0697 32E7              *
0698 32E7              LoadResource PROC EXPORT 
0699 32E7              *
0700 32E7              * This is the single place we call LoadResource in the control
0701 32E7              * manager.  We use a single entry point to simplify error 
0702 32E7              * handling.
0703 32E7              *
0704 32E7              * The routine that needs LoadResource, pushes space for the result
0705 32E7              * the type and id on the stack (just like making the tool call) 
0706 32E7              * and JSR's here.
0707 32E7              *
0708 32E7              * Any error results in a system death.
0709 32E7              *
0710 32E7              * Inputs:
0711 32E7              *                   HandleSpace : LONG
0712 32E7              *                   Type        : WORD
0713 32E7              *                   ID          : ID
0714 32E7              *
0715 32E7              * Outputs:
0716 32E7              *                   ResourceHandle
0717 32E7              *
0718 32E7              * External Refs:
0719 32E7              *                   none
0720 32E7              *
0721 32E7              * Entry Points:
0722 32E7                       EXPORT LoadCodeResource 
0723 32E7                       ENTRY CMDieHorribly 
0724 32E7              *
0725 32E7                       longa on                       ; mode
0726 32E7                       longi on 
0727 32E7              *
0728 32E7              ****************************************************************
0729 32E7
0730 32E7                       DefineStack 
0731 32E7              TheOrigD WORD 
0732 32E7              TheRTS   WORD 
0733 32E7              TheID    LONG 
0734 32E7              TheType  WORD 
0735 32E7              TheHandle LONG 
0736 32E7
0737 32E7 0B                    phd   
0738 32E8 3B                    tsc   
0739 32E9 5B                    tcd   
0740 32EA
0741 32EA 48                    pha   
0742 32EB 48                    pha   
0743 32EC D4 09                 pei   TheType
0744 32EE D4 07                 pei   TheID+2
0745 32F0 D4 05                 pei   TheID
0746 32F2 A2 1E 0E 22           _LoadResource 
0747 32F9
0748 32F9 B0 3D                 bcs   CMDieHorribly
0749 32FB
0750 32FB
0751 32FB 68                    pla   
0752 32FC 85 0B                 sta   TheHandle
0753 32FE 68                    pla   
0754 32FF 85 0D                 sta   TheHandle+2
0755 3301
0756 3301              GoodJob   
0757 3301 2B                    pld   
0758 3302 FA                    plx   
0759 3303 68                    pla   
0760 3304 68                    pla   
0761 3305 68                    pla   
0762 3306 DA                    phx   
0763 3307 60                    rts   
0764 3308
0765 3308
0766 3308 0B           LoadCodeResource phd   
0767 3309 3B                    tsc   
0768 330A 5B                    tcd   
0769 330B
0770 330B              *** added 8-Dec-91 DAL -- force prompt, no Cancel button
0771 330B 20 C9 35              jsr   GetAndSetPrefs
0772 330E 48                    pha   
0773 330F              *** end 8-Dec-91
0774 330F
0775 330F 48                    pha   
0776 3310 48                    pha   
0777 3311 D4 09                 pei   TheType
0778 3313 D4 07                 pei   TheID+2
0779 3315 D4 05                 pei   TheID
0780 3317 A2 1E 0E 22           _LoadResource 
0781 331E B0 18                 bcs   CMDieHorribly
0782 3320
0783 3320 68                    pla                            ; deref the handle and return the pointer
0784 3321 85 0B                 sta   TheHandle
0785 3323 68                    pla   
0786 3324 85 0D                 sta   TheHandle+2
0787 3326
0788 3326              *** added 8-Dec-91 DAL -- restore system preferences
0789 3326 68                    pla   
0790 3327 20 D9 35              jsr   SetPrefsToA
0791 332A              *** end 8-Dec-91 DAL
0792 332A
0793 332A A0 02 00              ldy   #2
0794 332D B7 0B                 lda   [TheHandle],y
0795 332F AA                    tax   
0796 3330 A7 0B                 lda   [TheHandle]
0797 3332 85 0B                 sta   TheHandle
0798 3334 86 0D                 stx   TheHandle+2
0799 3336 80 C9                 bra   GoodJob
0800 3338
0801 3338
0802 3338              ;-----------------------------------------------------------
0803 3338              ;
0804 3338              ; The load failed, so bring us all down!
0805 3338              ;
0806 3338
0807 3338              RamToTrash equ   $0002A0
0808 3338
0809 3338
0810 3338              CMDieHorribly  
0811 3338 85 0B                 sta   TheHandle
0812 333A
0813 333A F4 02 00 F4           PushLong #DeathMsg 
0814 3340 F4 00 00 F4           PushLong #RamToTrash 
0815 3346 AF 92 36 02           lda   >DeathMsg
0816 334A 29 FF 00              and   #$00FF
0817 334D 1A                    inc   a                        ;added 20-Nov-90 DAL
0818 334E F4 00 00              pea   $0000
0819 3351 48                    pha   
0820 3352 A2 02 2B 22           _BlockMove 
0821 3359
0822 3359 A5 05                 lda   TheID
0823 335B 20 D7 36              jsr   HexIt
0824 335E 8F D7 02 00           sta   >RamToTrash+IDStart-DeathMsg+4
0825 3362 8A                    txa   
0826 3363 8F D9 02 00           sta   >RamToTrash+IDStart-DeathMsg+6
0827 3367
0828 3367 A5 07                 lda   TheID+2
0829 3369 20 D7 36              jsr   HexIt
0830 336C 8F D3 02 00           sta   >RamToTrash+IDStart-DeathMsg
0831 3370 8A                    txa   
0832 3371 8F D5 02 00           sta   >RamToTrash+IDStart-DeathMsg+2
0833 3375
0834 3375 A5 09                 lda   TheType
0835 3377 20 D7 36              jsr   HexIt
0836 337A 8F C8 02 00           sta   >RamToTrash+TypeStart-DeathMsg
0837 337E 8A                    txa   
0838 337F 8F CA 02 00           sta   >RamToTrash+TypeStart-DeathMsg+2
0839 3383
0840 3383
0841 3383 D4 0B                 pei   TheHandle
0842 3385 F4 00 00 F4           PushLong #RamToTrash 
0843 338B A2 03 15 22           _SysFailMgr 
0844 3392
0845 3392 44           DeathMsg DC B:EndMsg-StartMsg
0846 3393 43 6F 75 6C  StartMsg DC B:'Could not load/unload resource.',13
0847 33B3 20 20 54 79           DC B:'  Type='
0848 33BA 20 20 20 20  TypeStart DC B:'    .',13
0849 33C0 20 20 49 44           DC B:'  ID='
0850 33C5 20 20 20 20  IDStart  DC B:'        .',13
0851 33CF 20 20 45 72           DC B:'  Error='
0852 33D7              EndMsg    
0853 33D7
0854 33D7 48           HexIt    pha   
0855 33D8 48                    pha   
0856 33D9 48                    pha   
0857 33DA A2 0B 2A 22           _HexIt 
0858 33E1 68                    pla   
0859 33E2 FA                    plx   
0860 33E3 60                    rts   
0861 33E4
0862 33E4                       ENDP 
0863 33E4
0864 33E4
0865 33E4              ;====================================================================
0866 33E4              ;
0867 33E4              ;          Push word value from data area.
0868 33E4              ;
0869 33E4              ;480=================================================================
0870 33E4              ;
0871 33E4              ;	EXPORT pushVvert_pen
0872 33E4              pushVvert_pen proc export               ;added PROC 8-Dec-91 DAL
0873 33E4 A0 48 00              ldy   #vert_pen
0874 33E7              ;
0875 33E7                       export enter480 
0876 33E7 FA           enter480 plx   
0877 33E8 B7 41                 lda   [<data],y
0878 33EA 48                    pha   
0879 33EB DA                    phx   
0880 33EC
0881 33EC 60                    rts   
0882 33ED
0883 33ED
0884 33ED              ;====================================================================
0885 33ED              ;
0886 33ED              ;          Push zero page addresses.
0887 33ED              ;
0888 33ED              ;  OUT:    Y = same as in.
0889 33ED              ;
0890 33ED              ;500=================================================================
0891 33ED                       EXPORT pushyrat 
0892 33ED              pushyrat  
0893 33ED              ;
0894 33ED A9 25 00              lda   #yrat
0895 33F0 80 03                 bra   pushzpage
0896 33F2              ;
0897 33F2                       EXPORT pushrect 
0898 33F2              pushrect                                ;
0899 33F2              ;
0900 33F2 A9 15 00              lda   #rect
0901 33F5              ;
0902 33F5                       EXPORT pushzpage 
0903 33F5              pushzpage                               ;
0904 33F5              ;
0905 33F5 FA                    plx                            Get return address.
0906 33F6              ;
0907 33F6 F4 00 00              pea   0
0908 33F9 48                    pha   
0909 33FA 7B                    tdc   
0910 33FB 18                    clc   
0911 33FC 63 01                 adc   1,s
0912 33FE 83 01                 sta   1,s
0913 3400              ;
0914 3400 DA                    phx                            Put return address back.
0915 3401
0916 3401 60                    rts   
0917 3402
0918 3402
0919 3402
0920 3402              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
0921 3402              ;
0922 3402              ;          Dereference Ctlhand.
0923 3402              ;
0924 3402              ;   IN:    Ctlhand = handle.
0925 3402              ;
0926 3402              ;  OUT:    a,x = (Ctlhand)
0927 3402              ;          Ctlptr = (Ctlhand)
0928 3402              ;
0929 3402              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
0930 3402              ;;;	EXPORT dereference
0931 3402              dereference proc export 
0932 3402              ;
0933 3402 A0 02 00              ldy   #2
0934 3405 B7 01                 lda   [<Ctlhand],y
0935 3407 85 07                 sta   <Ctlptr+2
0936 3409 AA                    tax   
0937 340A A7 01                 lda   [<Ctlhand]
0938 340C 85 05                 sta   <Ctlptr
0939 340E
0940 340E 60                    rts   
0941 340F
0942 340F
0943 340F              ;====================================================================
0944 340F              ;
0945 340F              ;        Draw a solid rectangle with border.
0946 340F              ;
0947 340F              ;  IN:     <rect = RECT to draw.
0948 340F              ;          <colorptr = pointer to color table.
0949 340F              ;          y = color of fill in bits 4-7.
0950 340F              ;          a = color of outline in bits 4-7.
0951 340F              ;
0952 340F              ;====================================================================
0953 340F              drawrect proc EXPORT 
0954 340F
0955 340F              fillColor equ   1
0956 340F              frameColor equ   fillColor+2
0957 340F
0958 340F              ;
0959 340F              ; --- Use special fill & frame RECT call ---------------------
0960 340F              ;
0961 340F 48                    pha                            Save outline color.
0962 3410 5A                    phy                            Save fill color.
0963 3411              ;
0964 3411 20 F2 36              jsr   pushrect                 Pass pointer to RECT to draw.
0965 3414 A3 07                 lda   frameColor+4,s           Get color of frame,
0966 3416 20 64 37              jsr   pushSmear                smear into 4 nibbles and push.
0967 3419 A3 07                 lda   fillColor+6,s            Get fill color,
0968 341B 20 64 37              jsr   pushSmear                smear into 4 nibbles and push.
0969 341E A2 12 0C 22           _SpecialRect 
0970 3425 90 3A                 bcc   exit                     No error?
0971 3427              ;
0972 3427 3B                    tsc                            Fix stack from SpecialRect call.
0973 3428 18                    clc   
0974 3429 69 08 00              adc   #8
0975 342C 1B                    tcs   
0976 342D              ;
0977 342D              ;
0978 342D              ; --- Use slower separate fill & frame calls -----------------
0979 342D              ;
0980 342D A2 04 36 22           _PenNormal 
0981 3434              ;
0982 3434 20 C9 3C              jsr   setvertpen               Set line size.
0983 3437              ;
0984 3437 A3 03                 lda   frameColor,s             Set pen color.
0985 3439 F0 0A                 beq   skip1                    Color already set?
0986 343B 20 64 37              jsr   pushSmear
0987 343E A2 04 37 22           _SetSolidPenPat 
0988 3445              ;
0989 3445 20 F2 36     skip1    jsr   pushrect                 Pass RECT to fill.
0990 3448 A3 05                 lda   fillColor+4,s
0991 344A A8                    tay   
0992 344B 20 21 3E              jsr   set_patt
0993 344E DA                    phx                            Push pointer to pattern.
0994 344F 5A                    phy   
0995 3450 A2 04 57 22           _FillRect 
0996 3457              ;
0997 3457 20 F2 36              jsr   pushrect                 Pass RECT to frame.
0998 345A A2 04 53 22           _FrameRect 
0999 3461              ;
1000 3461 7A           exit     ply                            Get rid of fill color.
1001 3462 68                    pla                            Get rid of outline color.
1002 3463
1003 3463 60                    rts   
1004 3464
1005 3464
1006 3464              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1007 3464              ;
1008 3464              ;          Smear color and push.
1009 3464              ;
1010 3464              ;   IN:    a = color to smear in bits 4-7.
1011 3464              ;
1012 3464              ;  OUT:    Color smeared into all 4 nibbles and left on stack.
1013 3464              ;
1014 3464              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = =
1015 3464 FA           pushSmear plx                           Get return address.
1016 3465              ;
1017 3465 48                    pha   
1018 3466 4A                    lsr   a
1019 3467 4A                    lsr   a
1020 3468 4A                    lsr   a
1021 3469 4A                    lsr   a
1022 346A 03 01                 ora   1,s
1023 346C 83 01                 sta   1,s
1024 346E EB                    xba   
1025 346F 03 01                 ora   1,s
1026 3471 83 01                 sta   1,s
1027 3473              ;
1028 3473 DA                    phx   
1029 3474
1030 3474 60                    rts   
1031 3475
1032 3475
1033 3475              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1034 3475              ;
1035 3475              ;        Get pointer to next control.
1036 3475              ;
1037 3475              ;   IN:  Ctlptr = pointer to a control.
1038 3475              ;
1039 3475              ;  OUT:  Equal flag = FALSE if ok, else no more controls.
1040 3475              ;
1041 3475              ;860= = = = = = = = = = = = = = = = = = = = = = = = = = =
1042 3475                       EXPORT next_Ctl 
1043 3475              next_Ctl                                ;
1044 3475              ;
1045 3475 A7 05                 lda   [<Ctlptr]
1046 3477 AA                    tax   
1047 3478 A0 02 00              ldy   #2
1048 347B B7 05                 lda   [<Ctlptr],y
1049 347D D0 03                 bne   store860
1050 347F 9B                    txy   
1051 3480 F0 09                 beq   exit860
1052 3482              ;
1053 3482 85 03        store860 sta   <Ctlhand+2
1054 3484 86 01                 stx   <Ctlhand
1055 3486 20 02 37              jsr   dereference              Ctlptr = (Ctlhand).
1056 3489 A5 06                 lda   <ctlptr+1                Set not equal flag.
1057 348B 60           exit860  rts   
1058 348C
1059 348C
1060 348C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1061 348C              ;
1062 348C              ;          Get bounds RECT of icon.
1063 348C              ;
1064 348C              ;   IN:    x = icon number.
1065 348C              ;
1066 348C              ;  OUT:    rect2+y2 = height of character.
1067 348C              ;          rect2+x2 = width of character.
1068 348C              ;
1069 348C              ;870= = = = = = = = = = = = = = = = = = = = = = = = = = =
1070 348C                       EXPORT get_csize 
1071 348C              get_csize                               ;
1072 348C              ;
1073 348C 86 2D                 stx   <work                    Pass character to test.
1074 348E
1075 348E              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1076 348E              ;
1077 348E              ;   IN:    work = character to get bounds of.
1078 348E              ;
1079 348E              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1080 348E                       EXPORT get_csize2 
1081 348E              get_csize2  
1082 348E A9 F8 37              lda   #getCharBounds
1083 3491              ;                                       Fall through to doIconFunc.
1084 3491              ;
1085 3491              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1086 3491              ;
1087 3491              ;          Perform a task that needs the
1088 3491              ;          icon font as the current font.
1089 3491              ;
1090 3491              ;   IN:    a = address of function to perform.
1091 3491              ;
1092 3491              ;880= = = = = = = = = = = = = = = = = = = = = = = = = = =
1093 3491                       EXPORT doIconFunc 
1094 3491              doIconFunc                              ;
1095 3491
1096 3491 48                    pha                            Save function to call.
1097 3492              ;
1098 3492              ;
1099 3492              ; --- Save state of grafPort ---------------------------------
1100 3492              ;
1101 3492 48                    pha                            Save original text face.
1102 3493 A2 04 9B 22           _GetTextFace 
1103 349A              ;
1104 349A 48                    pha                            Save original font flags.
1105 349B A2 04 99 22           _GetFontFlags 
1106 34A2              ;
1107 34A2 48                    pha                            Save original font ID.
1108 34A3 48                    pha   
1109 34A4 A2 04 D1 22           _GetFontID 
1110 34AB              ;
1111 34AB 48                    pha                            Save original font
1112 34AC 48                    pha   
1113 34AD A2 04 95 22           _GetFont 
1114 34B4              ;
1115 34B4              ;
1116 34B4              ; --- Clear text face, switch to icon font and call function ------------------
1117 34B4              ;
1118 34B4 F4 00 00              pea   0000
1119 34B7 A2 04 9A 22           _SetTextFace 
1120 34BE              ;
1121 34BE 20 FA 3D              jsr   pushVctl_font            Swicth to icon font.
1122 34C1 A2 04 94 22           _SetFont 
1123 34C8              ;
1124 34C8 F4 04 00              pea   4                        Use word of color.
1125 34CB A2 04 98 22           _SetFontFlags 
1126 34D2
1127 34D2 F4 D9 37              pea   returnAddr-1             Put return address on stack.
1128 34D5
1129 34D5              ;
1130 34D5              ; The stack at this point is
1131 34D5              ;
1132 34D5                       DefineStack 
1133 34D5              TheRetAddr word                         ; 1
1134 34D5              OrigFont long                           ; 3
1135 34D5              OrigFontID long                         ; 7
1136 34D5              OrigFontFlags word                      ; 11
1137 34D5              OrigTextFace word                       ; 13
1138 34D5              FuncToCall word                         ; 15
1139 34D5
1140 34D5 A3 0F                 lda   FuncToCall,s             Put address of function on stack,
1141 34D7 3A                    dec   a
1142 34D8 48                    pha   
1143 34D9
1144 34D9 60                    rts                            and dispatch to it.
1145 34DA              returnAddr                              ; 
1146 34DA
1147 34DA              ;
1148 34DA              ; --- Restore state of grafPort ------------------------------
1149 34DA              ;
1150 34DA A2 04 94 22           _SetFont Restore original font.
1151 34E1 A2 04 D0 22           _SetFontID Restore original font ID.
1152 34E8 A2 04 98 22           _SetFontFlags Restore original font flags.
1153 34EF A2 04 9A 22           _SetTextFace Restore original text face.
1154 34F6              ;
1155 34F6 68                    pla                            Address of function.
1156 34F7
1157 34F7 60                    rts   
1158 34F8              ;
1159 34F8              ;
1160 34F8              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1161 34F8              ;
1162 34F8              ;          Get size of character.
1163 34F8              ;
1164 34F8              ;   IN:    work = character to get size of.
1165 34F8              ;
1166 34F8              ;  OUT:    rect2+y2 = height of character.
1167 34F8              ;          rect2+x2 = width of character.
1168 34F8              ;
1169 34F8              ;890= = = = = = = = = = = = = = = = = = = = = = = = = = =
1170 34F8              getCharBounds                           ; 
1171 34F8              ;
1172 34F8 D4 2D                 pei   <work                    Pass character to get bounds of.
1173 34FA 20 08 3E              jsr   pushrect2                Store the bounds in 'rect2'.
1174 34FD A2 04 AC 22           _CharBounds 
1175 3504              ;
1176 3504 A0 21 00              ldy   #rect2+y2                Compute icon's heigth.
1177 3507 B7 41                 lda   [<data],y
1178 3509 38                    sec   
1179 350A A0 1D 00              ldy   #rect2+y1
1180 350D F7 41                 sbc   [<data],y
1181 350F A0 21 00              ldy   #rect2+y2
1182 3512 97 41                 sta   [<data],y
1183 3514              ;
1184 3514 A0 23 00              ldy   #rect2+x2                Compute icon's width.
1185 3517 B7 41                 lda   [<data],y
1186 3519 38                    sec   
1187 351A A0 1F 00              ldy   #rect2+x1
1188 351D F7 41                 sbc   [<data],y
1189 351F A0 23 00              ldy   #rect2+x2
1190 3522 97 41                 sta   [<data],y
1191 3524
1192 3524 60                    rts   
1193 3525
1194 3525
1195 3525              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1196 3525              ;
1197 3525              ;        Move control's CtlRect into 'rect'.
1198 3525              ;
1199 3525              ;   IN:  Ctlptr = control pointer.
1200 3525              ;
1201 3525              ;  OUT:  rect = CtlRect of part.
1202 3525              ;
1203 3525              ;900= = = = = = = = = = = = = = = = = = = = = = = = = = =
1204 3525                       EXPORT CMsetrect 
1205 3525              CMsetrect                               ;
1206 3525 A0 0E 00              ldy   #CtlRect+x2              Put CtlRect into rect.
1207 3528
1208 3528
1209 3528                       EXPORT CMsetrect2 
1210 3528              CMsetrect2                              ;
1211 3528 A2 06 00              ldx   #x2
1212 352B B7 05        lop900   lda   [<Ctlptr],y
1213 352D 95 15                 sta   <rect,x
1214 352F 88                    dey   
1215 3530 88                    dey   
1216 3531 CA                    dex   
1217 3532 CA                    dex   
1218 3533 10 F6                 bpl   lop900
1219 3535
1220 3535 60                    rts   
1221 3536              ;
1222 3536                       ENDP 
1223 3536
1224 3536
1225 3536              ;====================================================================
1226 3536              ;
1227 3536              ;          Static data area.
1228 3536              ;
1229 3536              ;====================================================================
1230 3536              staticRAM PROC 
1231 3536              ;
1232 3536              ;
1233 3536                       EXPORT arrowMap 
1234 3536 52 00 56 00  arrowMap DC W:uArrowH,dArrowH,lArrowH,rArrowH
1235 353E              ;
1236 353E                       EXPORT Dimmed 
1237 353E 55 AA 55 AA  dimmed   DC B:$55,$AA,$55,$AA,$55,$AA,$55,$AA Dithered mask for pen.
1238 3546                       EXPORT Nor_Mask 
1239 3546 FF FF FF FF  nor_mask DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF Normal mask for pen.
1240 354E              ;
1241 354E                       EXPORT clrBlack 
1242 354E 00 00        clrBlack DC W:$0000                     Solid black pattern.
1243 3550 00 00                 DC W:$0000
1244 3552 00 00                 DC W:$0000
1245 3554 00 00                 DC W:$0000
1246 3556 00 00                 DC W:$0000
1247 3558 00 00                 DC W:$0000
1248 355A 00 00                 DC W:$0000
1249 355C 00 00                 DC W:$0000
1250 355E 00 00                 DC W:$0000
1251 3560 00 00                 DC W:$0000
1252 3562 00 00                 DC W:$0000
1253 3564 00 00                 DC W:$0000
1254 3566 00 00                 DC W:$0000
1255 3568 00 00                 DC W:$0000
1256 356A 00 00                 DC W:$0000
1257 356C 00 00                 DC W:$0000
1258 356E
1259 356E                       EXPORT clrWhite 
1260 356E FF FF        clrWhite DC W:$FFFF                     Solid white pattern.
1261 3570 FF FF                 DC W:$FFFF
1262 3572 FF FF                 DC W:$FFFF
1263 3574 FF FF                 DC W:$FFFF
1264 3576 FF FF                 DC W:$FFFF
1265 3578 FF FF                 DC W:$FFFF
1266 357A FF FF                 DC W:$FFFF
1267 357C FF FF                 DC W:$FFFF
1268 357E FF FF                 DC W:$FFFF
1269 3580 FF FF                 DC W:$FFFF
1270 3582 FF FF                 DC W:$FFFF
1271 3584 FF FF                 DC W:$FFFF
1272 3586 FF FF                 DC W:$FFFF
1273 3588 FF FF                 DC W:$FFFF
1274 358A FF FF                 DC W:$FFFF
1275 358C FF FF                 DC W:$FFFF
1276 358E              ;
1277 358E              ;
1278 358E              ; --- Default color table for simple buttons -----------------
1279 358E              ;
1280 358E                       EXPORT butt_color 
1281 358E 00 00        butt_color DC W:$0000                   Outline.
1282 3590 F0 00                 DC W:$00F0                     Interior when normal.
1283 3592 00 00                 DC W:$0000                     Interior when selected.
1284 3594 F0 00                 DC W:$00F0                     Text when normal.
1285 3596 0F 00                 DC W:$000F                     Text when selected.
1286 3598              ;
1287 3598              ;
1288 3598              ; --- Default color table for check boxes and radio buttons --
1289 3598              ;
1290 3598                       EXPORT check_color 
1291 3598 00 00        check_color DC W:$0000                  Outline.
1292 359A F0 00                 DC W:$00F0                     Icon when unhilited.
1293 359C F0 00                 DC W:$00F0                     Icon when hilited.
1294 359E F0 00                 DC W:$00F0                     Title color.
1295 35A0              ;
1296 35A0              ;
1297 35A0              ; --- Default color table for scroll bars --------------------
1298 35A0              ;
1299 35A0                       EXPORT scroll_color 
1300 35A0 00 00        scroll_color DC W:$0000                 Outline.
1301 35A2 F0 00                 DC W:$00F0                     Arrow when normal.
1302 35A4 F0 00                 DC W:$00F0                     Arrow when selected.
1303 35A6 F0 00                 DC W:$00F0                     Arrow's box interior.
1304 35A8 F0 00                 DC W:$00F0                     Thumber when normal.
1305 35AA 00 00                 DC W:$0000                     Not used and should never be used.
1306 35AC              *****	DC.W	$010F	Page region interior.
1307 35AC C0 00                 DC W:$00C0                     Page region interior.  Experimental 20-Nov-90 DAL (This gets stored over by newresguts)
1308 35AE F0 00                 DC W:$00F0                     Interior color of inactive bar.
1309 35B0              ;
1310 35B0              ;
1311 35B0              ; --- Default color table for grow box -----------------------
1312 35B0              ;
1313 35B0                       EXPORT grow_color 
1314 35B0 00 00        grow_color DC W:$0000                   Outline.
1315 35B2 F0 00                 DC W:$00F0                     Interior when normal.
1316 35B4 0F 00                 DC W:$000F                     Interior when selected.
1317 35B6              ;
1318 35B6              ;
1319 35B6              ; --- Control Manager icon font -------------------------------
1320 35B6              ;
1321 35B6                       EXPORT ctl320 
1322 35B6              ctl320                                  ; 
1323 35B6              ;
1324 35B6 06 00                 DC W:$0006                     {offset word}
1325 35B8 D1 00                 DC W:$00D1                     {FontID}
1326 35BA 00 00                 DC W:$0000                     {style}
1327 35BC 0A 00                 DC W:$000A                     {size}
1328 35BE 00 01                 DC W:$0100                     {version}
1329 35C0 0D 00                 DC W:$000D                     {FBRext}
1330 35C2              ;
1331 35C2 01 90                 DC W:$9001                     {FontType}
1332 35C4 00 00                 DC W:$0000                     {FirstChar}
1333 35C6 10 00                 DC W:$0010                     {LastChar}
1334 35C8 0D 00                 DC W:$000D                     {WidMax}
1335 35CA 00 00                 DC W:$0000                     {KernMax}
1336 35CC F7 FF                 DC W:$FFF7                     {nDescent}
1337 35CE 0D 00                 DC W:$000D                     {fRectWidth}
1338 35D0 09 00                 DC W:$0009                     {FrectHeight}
1339 35D2 84 00                 DC W:132                       {owTLoc}
1340 35D4 00 00                 DC W:$0000                     {ascent}
1341 35D6 09 00                 DC W:$0009                     {descent}
1342 35D8 00 00                 DC W:$0000                     {leading}
1343 35DA 0C 00                 DC W:12                        {RowWords}
1344 35DC              ;
1345 35DC              ; BitImage:
1346 35DC FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$0F,$00,$F0,$0F,$00,$80,$40,$F8,$7C,$08,$04,$02,$01,$0F,$80,$00
1347 35F4 80 0F FF F0           DC B:$80,$0F,$FF,$F0,$07,$FF,$F3,$0C,$39,$C3,$0C,$39,$C1,$40,$E0,$88,$7C,$18,$0C,$03,$01,$88,$80,$00
1348 360C 80 0F 01 EC           DC B:$80,$0F,$01,$EC,$1B,$E0,$F4,$02,$60,$64,$F2,$6F,$62,$21,$F0,$88,$7C,$2F,$9F,$FE,$9F,$C8,$F8,$00
1349 3624 80 0F 01 E3           DC B:$80,$0F,$01,$E3,$63,$DB,$78,$01,$C0,$39,$F9,$DF,$B4,$13,$F8,$88,$7C,$40,$BF,$E0,$5F,$E8,$88,$00
1350 363C 80 0F 01 E0           DC B:$80,$0F,$01,$E0,$83,$C4,$78,$01,$C0,$3B,$FD,$DF,$BE,$3F,$FF,$8F,$FF,$80,$FF,$E0,$3F,$FF,$88,$00
1351 3654 80 0F 01 E3           DC B:$80,$0F,$01,$E3,$63,$DB,$78,$01,$C0,$39,$F9,$DF,$B2,$21,$F1,$04,$FE,$40,$BF,$E0,$5F,$E2,$08,$00
1352 366C 80 0F 01 EC           DC B:$80,$0F,$01,$EC,$1B,$E0,$F4,$02,$60,$64,$F2,$6F,$62,$21,$F0,$88,$7C,$2F,$9F,$FE,$9F,$C2,$08,$00
1353 3684 80 0F FF F0           DC B:$80,$0F,$FF,$F0,$07,$FF,$F3,$0C,$39,$C3,$0C,$39,$C2,$21,$F0,$50,$38,$18,$0C,$03,$01,$82,$08,$00
1354 369C FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$0F,$00,$F0,$0F,$03,$E1,$F0,$20,$10,$08,$04,$02,$01,$03,$F8,$00
1355 36B4              ;
1356 36B4              ; LocTable:
1357 36B4 00 00                 DC W:0                         0   Unchecked box normal.
1358 36B6 0D 00                 DC W:13                        1   Unchecked box hilited.
1359 36B8 1A 00                 DC W:26                        2   Checked box normal.
1360 36BA 27 00                 DC W:39                        3   Checked box hilited.
1361 36BC 34 00                 DC W:52                        4   Off radio button normal.
1362 36BE 40 00                 DC W:64                        5   Off radio button hilited.
1363 36C0 4C 00                 DC W:76                        6   On radio button normal.
1364 36C2 58 00                 DC W:88                        7   On radio button hilited.
1365 36C4 64 00                 DC W:100                       8   Up arrow normal.
1366 36C6 6D 00                 DC W:109                       9   Up arrow hilited.
1367 36C8 76 00                 DC W:118                       10  Down arrow normal.
1368 36CA 7F 00                 DC W:127                       11  Down arrow hilited.
1369 36CC 88 00                 DC W:136                       12  Left arrow normal.
1370 36CE 91 00                 DC W:145                       13  Left arrow hilited.
1371 36D0 9A 00                 DC W:154                       14  Right arrow normal.
1372 36D2 A3 00                 DC W:163                       15  Right arrow hilited.
1373 36D4 AC 00                 DC W:172                       16  Grow icon.
1374 36D6 B5 00                 DC W:181                       17  End of table.
1375 36D8 B5 00                 DC W:181                       18
1376 36DA              ;
1377 36DA              ; OWTable:
1378 36DA 0D 00                 DC W:13                        0   Unchecked box normal.
1379 36DC 0D 00                 DC W:13                        1   Unchecked box hilited.
1380 36DE 0D 00                 DC W:13                        2   Checked box normal.
1381 36E0 0D 00                 DC W:13                        3   Checked box hilited.
1382 36E2 0B 00                 DC W:11                        4   Off radio button normal.
1383 36E4 0B 00                 DC W:11                        5   Off radio button hilited.
1384 36E6 0B 00                 DC W:11                        6   On radio button normal.
1385 36E8 0B 00                 DC W:11                        7   On radio button hilited.
1386 36EA 09 00                 DC W:9                         8   Up arrow normal.
1387 36EC 09 00                 DC W:9                         9   Up arrow hilited.
1388 36EE 09 00                 DC W:9                         10  Down arrow normal.
1389 36F0 09 00                 DC W:9                         11  Down arrow hilited.
1390 36F2 09 00                 DC W:9                         12  Left arrow normal.
1391 36F4 09 00                 DC W:9                         13  Left arrow hilited.
1392 36F6 09 00                 DC W:9                         14  Right arrow normal.
1393 36F8 09 00                 DC W:9                         15  Right arrow hilited.
1394 36FA 09 00                 DC W:9                         16  Grow icon.
1395 36FC 04 04                 DC W:$0404                     17  End of table.
1396 36FE 00 00                 DC W:0                         18
1397 3700              ;
1398 3700              ;
1399 3700              ;
1400 3700              ;
1401 3700                       EXPORT ctl640 
1402 3700              ctl640                                  ; 
1403 3700              ;
1404 3700 06 00                 DC W:$0006                     ; {offset word}
1405 3702 D2 00                 DC W:$00D2                     ; {FontID}
1406 3704 00 00                 DC W:$0000                     ; {style}
1407 3706 0A 00                 DC W:$000A                     ; {size}
1408 3708 00 01                 DC W:$0100                     ; {version}
1409 370A 17 00                 DC W:$0017                     ; {FBRext}
1410 370C
1411 370C 01 90                 DC W:$9001                     ; {FontType}
1412 370E 00 00                 DC W:$0000                     ; {FirstChar}
1413 3710 10 00                 DC W:$0010                     ; {LastChar}
1414 3712 17 00                 DC W:$0017                     ; {WidMax}
1415 3714 00 00                 DC W:$0000                     ; {KernMax}
1416 3716 F7 FF                 DC W:$FFF7                     ; {nDescent}
1417 3718 17 00                 DC W:$0017                     ; {fRectWidth}
1418 371A 09 00                 DC W:$0009                     ; {FrectHeight}
1419 371C DE 00                 DC W:$00DE                     ; {owTLoc}
1420 371E 00 00                 DC W:$0000                     ; {ascent}
1421 3720 09 00                 DC W:$0009                     ; {descent}
1422 3722 00 00                 DC W:$0000                     ; {leading}
1423 3724 16 00                 DC W:$0016                     ; {RowWords}
1424 3726              ;
1425 3726              ; BitImage:
1426 3726 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$3F,$E0,$01,$FF
1427 3736 00 0F F8 00           DC B:$00,$0F,$F8,$00,$7F,$C0,$00,$C0,$00,$30,$00,$FF,$C0,$3F,$F0,$00
1428 3746 E0 00 38 00           DC B:$E0,$00,$38,$00,$1C,$00,$07,$00,$FF,$C0,$00,$00,$C0,$00,$07,$FF
1429 3756 FF FF C0 00           DC B:$FF,$FF,$C0,$00,$7F,$FF,$FF,$F1,$C0,$1C,$0F,$FF,$E0,$70,$07,$03
1430 3766 FF F8 03 30           DC B:$FF,$F8,$03,$30,$00,$FC,$00,$C0,$C0,$3F,$F0,$03,$60,$00,$F8,$00
1431 3776 1B 00 07 C0           DC B:$1B,$00,$07,$C0,$C0,$C0,$07,$F0,$C0,$00,$07,$F0,$00,$7F,$38,$03
1432 3786 9F F0 07 F6           DC B:$9F,$F0,$07,$F6,$00,$03,$3F,$01,$F9,$87,$F0,$CF,$C0,$7E,$0C,$0C
1433 3796 03 FF 00 C0           DC B:$03,$FF,$00,$C0,$C0,$3F,$F0,$0C,$7F,$C3,$FF,$FF,$F8,$C3,$FF,$F0
1434 37A6 C0 FF C0 7F           DC B:$C0,$FF,$C0,$7F,$C0,$00,$07,$F0,$00,$7F,$07,$1C,$1F,$CE,$39,$FC
1435 37B6 00 01 FC 00           DC B:$00,$01,$FC,$00,$7F,$1F,$FC,$7F,$1F,$1F,$30,$03,$0F,$FF,$C0,$C0
1436 37C6 C0 3F F0 30           DC B:$C0,$3F,$F0,$30,$00,$CF,$FF,$FC,$00,$33,$FF,$FC,$C0,$C0,$C3,$03
1437 37D6 C0 00 07 F0           DC B:$C0,$00,$07,$F0,$00,$7F,$00,$E0,$1F,$C1,$C1,$FC,$00,$01,$F8,$00
1438 37E6 3F 3F FE 7E           DC B:$3F,$3F,$FE,$7E,$3F,$8F,$FC,$0F,$FF,$FF,$FF,$C0,$FF,$FF,$FF,$C0
1439 37F6 00 FF FF FC           DC B:$00,$FF,$FF,$FC,$00,$0F,$FF,$FF,$FF,$C0,$C7,$0C,$C0,$00,$07,$F0
1440 3806 00 7F 07 1C           DC B:$00,$7F,$07,$1C,$1F,$CE,$39,$FC,$00,$01,$FC,$00,$7F,$1F,$FC,$7F
1441 3816 1F 1F 0C 0C           DC B:$1F,$1F,$0C,$0C,$03,$FF,$03,$00,$30,$FF,$FC,$30,$00,$CF,$FF,$FC
1442 3826 00 33 FF FC           DC B:$00,$33,$FF,$FC,$18,$00,$C3,$D8,$C0,$00,$07,$F0,$00,$7F,$38,$03
1443 3836 9F F0 07 F6           DC B:$9F,$F0,$07,$F6,$00,$03,$3F,$01,$F9,$87,$F0,$CF,$C0,$7E,$0C,$0C
1444 3846 03 FF 00 C0           DC B:$03,$FF,$00,$C0,$C0,$3F,$F0,$0C,$7F,$C3,$FF,$FF,$F8,$C3,$FF,$F0
1445 3856 18 00 C0 C0           DC B:$18,$00,$C0,$C0,$C0,$00,$07,$FF,$FF,$FF,$C0,$00,$7F,$FF,$FF,$F1
1446 3866 C0 1C 0F FF           DC B:$C0,$1C,$0F,$FF,$E0,$70,$07,$03,$FF,$F8,$0C,$0C,$03,$FF,$00,$33
1447 3876 00 0F C0 03           DC B:$00,$0F,$C0,$03,$60,$00,$F8,$00,$1B,$00,$07,$C0,$18,$00,$C7,$FE
1448 3886 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$3F,$E0,$01,$FF
1449 3896 00 0F F8 00           DC B:$00,$0F,$F8,$00,$7F,$C0,$0F,$FC,$03,$FF,$00,$0C,$00,$03,$00,$00
1450 38A6 E0 00 38 00           DC B:$E0,$00,$38,$00,$1C,$00,$07,$00,$1F,$FF,$C0,$AF
1451 38B2              ;
1452 38B2              ; LocTable:
1453 38B2 00 00                 DC W:$0000                     ; Char (00)
1454 38B4 17 00                 DC W:$0017                     ; Char (01)
1455 38B6 2E 00                 DC W:$002E                     ; Char (02)
1456 38B8 45 00                 DC W:$0045                     ; Char (03)
1457 38BA 5C 00                 DC W:$005C                     ; Char (04)
1458 38BC 71 00                 DC W:$0071                     ; Char (05)
1459 38BE 86 00                 DC W:$0086                     ; Char (06)
1460 38C0 9B 00                 DC W:$009B                     ; Char (07)
1461 38C2 B0 00                 DC W:$00B0                     ; Char (08)
1462 38C4 C2 00                 DC W:$00C2                     ; Char (09)
1463 38C6 D4 00                 DC W:$00D4                     ; Char (0A)
1464 38C8 E6 00                 DC W:$00E6                     ; Char (0B)
1465 38CA F8 00                 DC W:$00F8                     ; Char (0C)
1466 38CC 0A 01                 DC W:$010A                     ; Char (0D)
1467 38CE 1C 01                 DC W:$011C                     ; Char (0E)
1468 38D0 2E 01                 DC W:$012E                     ; Char (0F)
1469 38D2 40 01                 DC W:$0140                     ; Char (10)
1470 38D4 52 01                 DC W:$0152                     ; Char (11)
1471 38D6 52 01                 DC W:$0152                     ; Char (12)
1472 38D8              ;
1473 38D8              ; OWTable:
1474 38D8 17 00                 DC W:$0017                     ; Char (00)
1475 38DA 17 00                 DC W:$0017                     ; Char (01)
1476 38DC 17 00                 DC W:$0017                     ; Char (02)
1477 38DE 17 00                 DC W:$0017                     ; Char (03)
1478 38E0 15 00                 DC W:$0015                     ; Char (04)
1479 38E2 15 00                 DC W:$0015                     ; Char (05)
1480 38E4 15 00                 DC W:$0015                     ; Char (06)
1481 38E6 15 00                 DC W:$0015                     ; Char (07)
1482 38E8 12 00                 DC W:$0012                     ; Char (08)
1483 38EA 12 00                 DC W:$0012                     ; Char (09)
1484 38EC 12 00                 DC W:$0012                     ; Char (0A)
1485 38EE 12 00                 DC W:$0012                     ; Char (0B)
1486 38F0 12 00                 DC W:$0012                     ; Char (0C)
1487 38F2 12 00                 DC W:$0012                     ; Char (0D)
1488 38F4 12 00                 DC W:$0012                     ; Char (0E)
1489 38F6 12 00                 DC W:$0012                     ; Char (0F)
1490 38F8 12 00                 DC W:$0012                     ; Char (10)
1491 38FA 04 04                 DC W:$0404                     ; Char 'H'
1492 38FC 00 00                 DC W:$0000                     ; Char 'I'
1493 38FE              ;
1494 38FE                       ENDP 
1495 38FE
1496 38FE
1497 38FE
1498 38FE              **********************************************************************
1499 38FE              *
1500 38FE              * $3C10 SetCtlValueByID -- added 15-Jul-92 DAL
1501 38FE              *
1502 38FE              * Inputs:
1503 38FE              *   Value                 (WORD)
1504 38FE              *   Window Pointer        (LONG)
1505 38FE              *   Control ID            (LONG)
1506 38FE              *
1507 38FE              **********************************************************************
1508 38FE              SetCtlValueByID PROC EXPORT 
1509 38FE 0B                    phd   
1510 38FF 3B                    tsc   
1511 3900 5B                    tcd   
1512 3901
1513 3901              @ctlID   equ   9
1514 3901              @windPtr equ   @ctlID+4
1515 3901              @value   equ   @windPtr+4
1516 3901
1517 3901 20 1A 3C              jsr   CtlGetHandle             ;into XY
1518 3904 B0 0B                 bcs   @error
1519 3906
1520 3906 D4 11                 pei   <@value
1521 3908 DA                    phx   
1522 3909 5A                    phy   
1523 390A A2 10 19 22           _SetCtlValue 
1524 3911
1525 3911 AA           @error   tax   
1526 3912 2B                    pld   
1527 3913
1528 3913                       export CtlStrip10Bytes 
1529 3913 A0 0A 00     CtlStrip10Bytes ldy   #10
1530 3916 5C 84 01 E1           jml   $e10184                  ;ToStrip
1531 391A
1532 391A
1533 391A
1534 391A                       export CtlGetHandle 
1535 391A              CtlGetHandle  
1536 391A
1537 391A              @ctlID   equ   9
1538 391A              @windPtr equ   @ctlID+4
1539 391A
1540 391A 48                    pha   
1541 391B 48                    pha   
1542 391C D4 0F                 pei   <@windPtr+2
1543 391E D4 0D                 pei   <@windPtr
1544 3920 D4 0B                 pei   <@ctlID+2
1545 3922 D4 09                 pei   <@ctlID
1546 3924 A2 10 30 22           _GetCtlHandleFromID 
1547 392B 7A                    ply   
1548 392C FA                    plx   
1549 392D 60                    rts   
1550 392E
1551 392E                       ENDP 
1552 392E
1553 392E
1554 392E              **********************************************************************
1555 392E              *
1556 392E              * $3D10 GetCtlValueByID -- added 15-Jul-92 DAL
1557 392E              *
1558 392E              * Inputs:
1559 392E              *   Space for result      (WORD)
1560 392E              *   Window Pointer        (LONG)
1561 392E              *   Control ID            (LONG)
1562 392E              *
1563 392E              **********************************************************************
1564 392E              GetCtlValueByID PROC EXPORT 
1565 392E                       import CtlGetHandle 
1566 392E
1567 392E 0B                    phd   
1568 392F 3B                    tsc   
1569 3930 5B                    tcd   
1570 3931
1571 3931              @ctlID   equ   9
1572 3931              @windPtr equ   @ctlID+4
1573 3931              @result  equ   @windPtr+4
1574 3931
1575 3931 64 11                 stz   <@result
1576 3933
1577 3933 20 1A 3C              jsr   CtlGetHandle             ;into XY
1578 3936 B0 0D                 bcs   @error
1579 3938
1580 3938 48                    pha   
1581 3939 DA                    phx   
1582 393A 5A                    phy   
1583 393B A2 10 1A 22           _GetCtlValue 
1584 3942 FA                    plx   
1585 3943 86 11                 stx   <@result
1586 3945
1587 3945 AA           @error   tax   
1588 3946 2B                    pld   
1589 3947
1590 3947                       export CtlStrip8Bytes 
1591 3947 A0 08 00     CtlStrip8Bytes ldy   #8
1592 394A 5C 84 01 E1           jml   $e10184                  ;ToStrip
1593 394E
1594 394E                       ENDP 
1595 394E
1596 394E
1597 394E              **********************************************************************
1598 394E              *
1599 394E              * $3E10 InvalOneCtlByID -- added 15-Jul-92 DAL
1600 394E              *
1601 394E              * Inputs:
1602 394E              *   Window Pointer        (LONG)
1603 394E              *   Control ID            (LONG)
1604 394E              *
1605 394E              **********************************************************************
1606 394E              InvalOneCtlByID PROC EXPORT 
1607 394E                       import CtlStrip8Bytes,CtlGetHandle 
1608 394E
1609 394E 0B                    phd   
1610 394F 3B                    tsc   
1611 3950 5B                    tcd   
1612 3951
1613 3951              @ctlID   equ   9
1614 3951              @windPtr equ   @ctlID+4
1615 3951
1616 3951 20 1A 3C              jsr   CtlGetHandle
1617 3954 B0 57                 bcs   @error
1618 3956
1619 3956              @handle  equ   @ctlID                   ;re-use our direct page space
1620 3956              @ptr     equ   @windPtr
1621 3956
1622 3956 86 0B                 stx   <@handle+2
1623 3958 84 09                 sty   <@handle
1624 395A A0 04 00              ldy   #4
1625 395D B7 09                 lda   [<@handle],y
1626 395F 48                    pha   
1627 3960 09 00 80              ora   #$8000
1628 3963 97 09                 sta   [<@handle],y
1629 3965 88                    dey   
1630 3966 88                    dey   
1631 3967 B7 09                 lda   [<@handle],y
1632 3969 85 0F                 sta   <@ptr+2
1633 396B A7 09                 lda   [<@handle]
1634 396D 85 0D                 sta   <@ptr
1635 396F
1636 396F 48                    pha   
1637 3970 48                    pha   
1638 3971 A2 04 1C 22           _GetPort 
1639 3978 A0 06 00              ldy   #6                       ;offset to ctlOwner+2
1640 397B B7 0D                 lda   [<@ptr],y
1641 397D 48                    pha   
1642 397E 88                    dey   
1643 397F 88                    dey   
1644 3980 B7 0D                 lda   [<@ptr],y
1645 3982 48                    pha   
1646 3983 A2 04 1B 22           _SetPort 
1647 398A A6 0F                 ldx   <@ptr+2
1648 398C A5 0D                 lda   <@ptr
1649 398E 69 08 00              adc   #8
1650 3991 90 01                 bcc   @1
1651 3993 E8                    inx   
1652 3994 DA           @1       phx   
1653 3995 48                    pha   
1654 3996 A2 0E 3A 22           _InvalRect 
1655 399D A2 04 1B 22           _SetPort 
1656 39A4
1657 39A4 A0 04 00              ldy   #4
1658 39A7 68                    pla   
1659 39A8 97 09                 sta   [<@handle],y             ;unlock handle
1660 39AA A9 00 00              lda   #0                       ;no error
1661 39AD
1662 39AD AA           @error   tax   
1663 39AE 2B                    pld   
1664 39AF 80 96                 bra   CtlStrip8Bytes
1665 39B1
1666 39B1                       ENDP 
1667 39B1
1668 39B1
1669 39B1              **********************************************************************
1670 39B1              *
1671 39B1              * $3F10 HiliteCtlByID -- added 15-Jul-92 DAL
1672 39B1              *
1673 39B1              * Inputs:
1674 39B1              *   Hilite                (WORD)
1675 39B1              *   Window Pointer        (LONG)
1676 39B1              *   Control ID            (LONG)
1677 39B1              *
1678 39B1              **********************************************************************
1679 39B1              HiliteCtlByID PROC EXPORT 
1680 39B1                       import CtlStrip10Bytes,CtlGetHandle 
1681 39B1
1682 39B1 0B                    phd   
1683 39B2 3B                    tsc   
1684 39B3 5B                    tcd   
1685 39B4
1686 39B4              @ctlID   equ   9
1687 39B4              @windPtr equ   @ctlID+4
1688 39B4              @Hilite  equ   @windPtr+4
1689 39B4
1690 39B4 20 1A 3C              jsr   CtlGetHandle             ;into XY
1691 39B7 B0 0B                 bcs   @error
1692 39B9
1693 39B9 D4 11                 pei   <@Hilite
1694 39BB DA                    phx   
1695 39BC 5A                    phy   
1696 39BD A2 10 11 22           _HiliteControl 
1697 39C4
1698 39C4 AA           @error   tax   
1699 39C5 2B                    pld   
1700 39C6 82 4A FF              brl   CtlStrip10Bytes
1701 39C9
1702 39C9                       ENDP 
1703 39C9
1704 39C9
1705 39C9
1706 39C9              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
1707 39C9              ;          Set pen size to:
1708 39C9              ;                width = vert_pen.
1709 39C9              ;                height = 1.
1710 39C9              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
1711 39C9              ;	ENTRY SetVertPen
1712 39C9              setvertpen proc export 
1713 39C9              ;
1714 39C9 20 E4 36              jsr   pushVvert_pen
1715 39CC F4 01 00              pea   1
1716 39CF A2 04 2C 22           _SetPenSize 
1717 39D6
1718 39D6 60                    rts   
1719 39D7
1720 39D7
1721 39D7
1722 39D7              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1723 39D7              ;          Push a pointer to inside a record.
1724 39D7              ;110= = = = = = = = = = = = = = = = = = = = = = = = = = =
1725 39D7              ;
1726 39D7              ;   IN:    Ctlptr = pointer to record.
1727 39D7              ;          a = offset into the record.
1728 39D7              ;
1729 39D7              ;  OUT:    pointer on stack.
1730 39D7              ;
1731 39D7              ;	export pushrecord
1732 39D7              pushrecord proc export 
1733 39D7              ;
1734 39D7 7A                    ply                            Get return address.
1735 39D8              ;
1736 39D8 A6 07                 ldx   <Ctlptr+2
1737 39DA 18                    clc   
1738 39DB 65 05                 adc   <Ctlptr
1739 39DD 90 01                 bcc   ok110
1740 39DF E8                    inx   
1741 39E0 DA           ok110    phx   
1742 39E1 48                    pha   
1743 39E2              ;
1744 39E2 5A                    phy                            Return address back.
1745 39E3 60                    rts   
1746 39E4
1747 39E4
1748 39E4
1749 39E4              ;====================================================================
1750 39E4              ;
1751 39E4              ;          Set text color and writing mode.
1752 39E4              ;
1753 39E4              ;   IN:    a = normal color index into color table.
1754 39E4              ;          colorptr = pointer to color table.
1755 39E4              ;          state = 0 for normal, 2 for hilited.
1756 39E4              ;
1757 39E4              ;====================================================================
1758 39E4              set_textmode proc EXPORT 
1759 39E4
1760 39E4 A0 50 00              ldy   #state
1761 39E7 18                    clc   
1762 39E8 77 41                 adc   [<data],y
1763 39EA A8                    tay   
1764 39EB B7 11                 lda   [<colorptr],y
1765 39ED 48                    pha                            Save color.
1766 39EE 29 0F 00              and   #$000F                   Just text color.
1767 39F1 20 20 3D              jsr   smear                    Duplicate color in all 4 nibbles.
1768 39F4 48                    pha                            Pass color of title.
1769 39F5 A2 04 A0 22           _SetForeColor                  Set text color.
1770 39FC              ;
1771 39FC 68                    pla                            Restore saved color.
1772 39FD 29 F0 00              and   #$00F0
1773 3A00 48                    pha   
1774 3A01 4A                    lsr   a                        Get background color.
1775 3A02 4A                    lsr   a
1776 3A03 4A                    lsr   a
1777 3A04 4A                    lsr   a
1778 3A05 03 01                 ora   1,s
1779 3A07 83 01                 sta   1,s
1780 3A09 EB                    xba   
1781 3A0A 03 01                 ora   1,s
1782 3A0C 83 01                 sta   1,s
1783 3A0E A2 04 A2 22           _SetBackColor 
1784 3A15              ;
1785 3A15 F4 00 00              pea   0                        Copy mode.
1786 3A18 A2 04 9C 22           _SetTextMode 
1787 3A1F              ;
1788 3A1F 60                    rts   
1789 3A20
1790 3A20                       ENDP 
1791 3A20
1792 3A20
1793 3A20              ;====================================================================
1794 3A20              ;
1795 3A20              ;          Smear color into all 4 nibbles.
1796 3A20              ;
1797 3A20              ;   IN:    a = low nibble is color.
1798 3A20              ;
1799 3A20              ;  OUT:    a = low nibble duplicated into all 4 nibbles.
1800 3A20              ;          x = trash.
1801 3A20              ;
1802 3A20              ;====================================================================
1803 3A20              smear    proc EXPORT 
1804 3A20              ;
1805 3A20 29 0F 00              and   #$000F
1806 3A23 48                    pha   
1807 3A24 0A                    asl   a
1808 3A25 0A                    asl   a
1809 3A26 0A                    asl   a
1810 3A27 0A                    asl   a
1811 3A28 03 01                 ora   1,s
1812 3A2A 83 01                 sta   1,s
1813 3A2C EB                    xba   
1814 3A2D 03 01                 ora   1,s
1815 3A2F FA                    plx   
1816 3A30
1817 3A30 60                    rts   
1818 3A31
1819 3A31                       ENDP 
1820 3A31
1821 3A31
1822 3A31              **********************************************************************
1823 3A31              *
1824 3A31              * ComputeScrollColor
1825 3A31              *
1826 3A31              * Look for a good gray in a likely-looking color palette.  If we can't
1827 3A31              * find one, then use $010F (the old checkerboard pattern).  If we find one,
1828 3A31              * use $00x0.
1829 3A31              *
1830 3A31              * We store the new pattern into scroll_color+12, the page color for
1831 3A31              * the default scroll bar color table.  If we change the value, we
1832 3A31              * call RefreshDesktop(0) to redraw any scroll bars that happen to be
1833 3A31              * using the default color table.
1834 3A31              *
1835 3A31              **********************************************************************
1836 3A31
1837 3A31              *** 9-Dec-91 DAL -- made this into a proc.  Made it store the new value itself,
1838 3A31              *** and also refresh the screen if needed.
1839 3A31
1840 3A31              ComputeScrollColor proc export  
1841 3A31
1842 3A31 48                    pha   
1843 3A32 A2 04 17 22           _GetMasterSCB 
1844 3A39 68                    pla   
1845 3A3A 29 80 00              and   #$0080
1846 3A3D F0 05                 beq   @320
1847 3A3F
1848 3A3F A9 C0 00              lda   #myScrollPatt640
1849 3A42 80 44                 bra   @storeNewValue
1850 3A44
1851 3A44              @320      
1852 3A44 48                    pha   
1853 3A45 F4 64 00              pea   100
1854 3A48 A2 04 13 22           _GetSCB 
1855 3A4F 68                    pla   
1856 3A50 29 0F 00              and   #$000f
1857 3A53 0A                    asl   a
1858 3A54 0A                    asl   a
1859 3A55 0A                    asl   a
1860 3A56 0A                    asl   a
1861 3A57 0A                    asl   a                        ;*32 = index into color stuff
1862 3A58 AA                    tax   
1863 3A59 A0 10 00              ldy   #16
1864 3A5C BF 00 9E E1  @search  lda   $e19e00,x
1865 3A60 48                    pha   
1866 3A61
1867 3A61 C9 55 05              cmp   #$0555                   ;compare against 4 acceptable gray levels
1868 3A64 F0 1A                 beq   @found
1869 3A66 C9 66 06              cmp   #$0666
1870 3A69 F0 15                 beq   @found
1871 3A6B C9 77 07              cmp   #$0777
1872 3A6E F0 10                 beq   @found
1873 3A70 C9 88 08              cmp   #$0888
1874 3A73 F0 0B                 beq   @found
1875 3A75
1876 3A75 68           @noGood  pla   
1877 3A76 E8                    inx   
1878 3A77 E8                    inx   
1879 3A78 88                    dey   
1880 3A79 D0 E1                 bne   @search
1881 3A7B
1882 3A7B A9 0F 01              lda   #$010f
1883 3A7E 80 08                 bra   @storeNewValue
1884 3A80
1885 3A80 68           @found   pla   
1886 3A81 8A                    txa   
1887 3A82 0A                    asl   a
1888 3A83 0A                    asl   a
1889 3A84 0A                    asl   a
1890 3A85 29 F0 00              and   #$00f0
1891 3A88 CF AC 38 02  @storeNewValue cmp   >scroll_color+12
1892 3A8C 8F AC 38 02           sta   >scroll_color+12
1893 3A90 F0 0D                 beq   @noChange
1894 3A92
1895 3A92              *** added 14-Jan-92 DAL -- cause a RefreshDesktop to happen later
1896 3A92 F4 02 00 F4           pushlong #refreshDeskTask 
1897 3A98 A2 05 1F 22           _AddToRunQ 
1898 3A9F              *** end 14-Jan-92
1899 3A9F
1900 3A9F 60           @noChange rts   
1901 3AA0              *** end 9-Dec-91 DAL
1902 3AA0
1903 3AA0
1904 3AA0              *** added 14-Jan-92 DAL
1905 3AA0              *
1906 3AA0              * refreshDeskTask -- redraws the desktop once, when it's safe
1907 3AA0              * (this task removes itself from the queue)
1908 3AA0              *
1909 3AA0                       export refreshDeskTask 
1910 3AA0 00 00 00 00  refreshDeskTask DC L:0                  ;reserved
1911 3AA4 00 00                 DC W:0                         ;call as often as possible
1912 3AA6 5A A5                 DC W:$a55a                     ;signature
1913 3AA8 00 00 00 00           DC L:0                         ;reserved for system
1914 3AAC A9 00 00     entry    lda   #0
1915 3AAF 48                    pha   
1916 3AB0 48                    pha   
1917 3AB1 A2 0E 39 22           _RefreshDesktop 
1918 3AB8 90 07                 bcc   @fine
1919 3ABA C9 10 00              cmp   #$10
1920 3ABD B0 02                 bcs   @fine
1921 3ABF 68                    pla   
1922 3AC0 68                    pla                            ;clean up after dispatcher error (paranoia)
1923 3AC1              @fine     
1924 3AC1                       export RemoveRefreshTask 
1925 3AC1 F4 02 00 F4  RemoveRefreshTask pushlong #refreshDeskTask 
1926 3AC7 A2 05 20 22           _RemoveFromRunQ 
1927 3ACE 6B                    rtl   
1928 3ACF              *** end 14-Jan-92
1929 3ACF
1930 3ACF                       ENDP 
1931 3ACF
1932 3ACF
1933 3ACF
1934 3ACF
1935 3ACF
1936 3ACF              ;
1937 3ACF              ;
1938 3ACF              ;====================================================================
1939 3ACF              ;        ( op1 * op2 ) / op3
1940 3ACF              ;
1941 3ACF              ;   IN:  x = op1.
1942 3ACF              ;        y = op2.
1943 3ACF              ;        a = op3.
1944 3ACF              ;
1945 3ACF              ;  OUT:  x = result.
1946 3ACF              ;300=================================================================
1947 3ACF              ;	EXPORT fraction
1948 3ACF              fraction proc export 
1949 3ACF              ;
1950 3ACF 48                    pha                            Save op3.
1951 3AD0              ;
1952 3AD0 48                    pha                            Space for LongDivide remainder high.
1953 3AD1 48                    pha                            Space for LongDivide remainder low.
1954 3AD2              ;
1955 3AD2 48                    pha                            Space for LongDivide quotient high.
1956 3AD3 48                    pha                            Space for LongDivide quotient low.
1957 3AD4              ;
1958 3AD4              ;
1959 3AD4              ; --- ( op1 * op2 ) ------------------------------
1960 3AD4              ;
1961 3AD4 48                    pha                            Space for Multiply result.
1962 3AD5 48                    pha                            Space for Multiply result.
1963 3AD6              ;
1964 3AD6 DA                    phx                            Pass op1.
1965 3AD7 5A                    phy                            Pass op2.
1966 3AD8 A2 0B 09 22           _Multiply 
1967 3ADF              ;
1968 3ADF              ;
1969 3ADF              ; --- ( Result ) / op3 ---------------------------
1970 3ADF              ;
1971 3ADF              ;                                       Space for result already on stack.
1972 3ADF              ;                                       Numerator is multiply result on stack.
1973 3ADF F4 00 00              pea   0                        Pass high word of op3 as denominator.
1974 3AE2 A3 0B                 lda   11,s
1975 3AE4 48                    pha                            Pass low word of op3 as denominator.
1976 3AE5 A2 0B 0D 22           _LongDivide 
1977 3AEC              ;
1978 3AEC              ;
1979 3AEC              ; --- Round off quotient --------------------------
1980 3AEC              ;
1981 3AEC FA                    plx                            Quotient.
1982 3AED A3 07                 lda   7,s                      Get op3.
1983 3AEF 4A                    lsr   a                        Halve of that.
1984 3AF0 C3 03                 cmp   3,s                      Is it greater that the remainder?
1985 3AF2 B0 01                 bcs   skip300
1986 3AF4 E8                    inx                            Round up.
1987 3AF5              ;
1988 3AF5              ;
1989 3AF5              ; --- Fix up stack and exit ------------------------
1990 3AF5              ;
1991 3AF5 68           skip300  pla                            Pull quotient high word.
1992 3AF6 68                    pla                            Pull remainder low word.
1993 3AF7 68                    pla                            Pull remainder high word.
1994 3AF8              ;
1995 3AF8 68                    pla                            Pull op3.
1996 3AF9
1997 3AF9 60                    rts                            x = result.
1998 3AFA
1999 3AFA
2000 3AFA
2001 3AFA              ;====================================================================
2002 3AFA              ;
2003 3AFA              ;          Push long value in data area.
2004 3AFA              ;
2005 3AFA              ;460=================================================================
2006 3AFA              ;
2007 3AFA              ;	EXPORT pushVctl_font
2008 3AFA              pushVctl_font proc export 
2009 3AFA A0 46 00              ldy   #ctl_font+2
2010 3AFD              ;
2011 3AFD                       export enter460 
2012 3AFD FA           enter460 plx   
2013 3AFE B7 41                 lda   [<data],y
2014 3B00 48                    pha   
2015 3B01 88                    dey   
2016 3B02 88                    dey   
2017 3B03 B7 41                 lda   [<data],y
2018 3B05 48                    pha   
2019 3B06 DA                    phx   
2020 3B07
2021 3B07 60                    rts   
2022 3B08
2023 3B08
2024 3B08              ;====================================================================
2025 3B08              ;
2026 3B08              ;          Push address of variable in data area.
2027 3B08              ;
2028 3B08              ;470=================================================================
2029 3B08              ;	EXPORT pushrect2
2030 3B08              pushrect2 proc export 
2031 3B08 A9 1D 00              lda   #rect2
2032 3B0B 80 00                 bra   enter470
2033 3B0D              ;
2034 3B0D              enter470 proc export 
2035 3B0D FA                    plx   
2036 3B0E              ;
2037 3B0E 18                    clc   
2038 3B0F 65 41                 adc   <data
2039 3B11 A8                    tay   
2040 3B12 A9 00 00              lda   #0
2041 3B15 65 43                 adc   <data+2
2042 3B17 48                    pha   
2043 3B18 5A                    phy   
2044 3B19              ;
2045 3B19 DA                    phx   
2046 3B1A
2047 3B1A 60                    rts   
2048 3B1B
2049 3B1B
2050 3B1B
2051 3B1B              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2052 3B1B              ;
2053 3B1B              ;          ReadMoreFlags
2054 3B1B              ;
2055 3B1B              ;   IN:    Ctlhand = handle
2056 3B1B              ;          CtlPtr  = ptr
2057 3B1B              ;
2058 3B1B              ;  OUT:    a-reg = MoreFlags
2059 3B1B              ;
2060 3B1B              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
2061 3B1B              ;	EXPORT ReadMoreFlags
2062 3B1B              ReadMoreFlags proc export 
2063 3B1B A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
2064 3B1E B7 05                 lda   [<Ctlptr],y
2065 3B20 60                    rts   
2066 3B21
2067 3B21
2068 3B21
2069 3B21              ;====================================================================
2070 3B21              ;
2071 3B21              ;        Smear a mono bit image into color.
2072 3B21              ;
2073 3B21              ;  IN:   y = pattern type in high byte,
2074 3B21              ;            pattern color number in high nybble of low byte,
2075 3B21              ;            background color in low nibble of low byte.
2076 3B21              ;
2077 3B21              ; OUT:   x = high word address of pattern.
2078 3B21              ;        y = low word address of pattern.
2079 3B21              ;
2080 3B21              ;800=================================================================
2081 3B21              set_patt proc EXPORT 
2082 3B21
2083 3B21 98                    tya                            Special case, solid pattern.
2084 3B22 29 00 FF              and   #$FF00
2085 3B25 D0 17                 bne   begin800
2086 3B27
2087 3B27              ;
2088 3B27              ; --- Special case black and white --------------------------------
2089 3B27              ;
2090 3B27 98                    tya   
2091 3B28 29 F0 00              and   #$00F0
2092 3B2B F0 0A                 beq   @black
2093 3B2D C9 F0 00              cmp   #$00F0
2094 3B30 D0 0C                 bne   begin800
2095 3B32              ;
2096 3B32 A0 6E 38              ldy   #clrWhite
2097 3B35 80 03                 bra   exit801
2098 3B37              ;
2099 3B37 A0 4E 38     @black   ldy   #clrBlack
2100 3B3A A2 02 00     exit801  ldx   #clrBlack>>16
2101 3B3D
2102 3B3D 60                    rts   
2103 3B3E
2104 3B3E              ;
2105 3B3E              ; --- Fill pattern buffer with pattern color ----------
2106 3B3E              ;
2107 3B3E              ;  y = color/pattern
2108 3B3E              ;
2109 3B3E D4 2F        begin800 pei   <work+2                  Save work.
2110 3B40 D4 2D                 pei   <work
2111 3B42              ;
2112 3B42 A6 43                 ldx   <data+2
2113 3B44 A5 41                 lda   <data
2114 3B46 18                    clc   
2115 3B47 69 00 00              adc   #pattern
2116 3B4A 90 01                 bcc   store800
2117 3B4C E8                    inx   
2118 3B4D 85 2D        store800 sta   <work
2119 3B4F 86 2F                 stx   <work+2
2120 3B51              ;
2121 3B51              ;
2122 3B51 98                    tya                            Get pattern color.
2123 3B52 4A                    lsr   a
2124 3B53 4A                    lsr   a
2125 3B54 4A                    lsr   a
2126 3B55 4A                    lsr   a
2127 3B56 20 DA 3E              jsr   getcolor                 Smear color into all four nibbles.
2128 3B59              ;
2129 3B59 87 2D                 sta   [<work]
2130 3B5B C0 00 01              cpy   #$0100
2131 3B5E B0 0B                 bcs   dither800
2132 3B60              ;
2133 3B60 A0 1E 00              ldy   #30
2134 3B63 97 2D        lop800   sta   [<work],y
2135 3B65 88                    dey   
2136 3B66 88                    dey   
2137 3B67 D0 FA                 bne   lop800
2138 3B69 80 59                 bra   exit800
2139 3B6B              ;
2140 3B6B              ;
2141 3B6B              ; --- Special dither pattern -------------------------------------------
2142 3B6B              ;
2143 3B6B 98           dither800 tya   
2144 3B6C 20 DA 3E              jsr   getcolor
2145 3B6F A8                    tay   
2146 3B70 29 F0 F0              and   #$F0F0
2147 3B73 48                    pha   
2148 3B74 A7 2D                 lda   [<work]
2149 3B76 29 0F 0F              and   #$0F0F
2150 3B79 03 01                 ora   1,s
2151 3B7B 83 01                 sta   1,s
2152 3B7D              ;
2153 3B7D 98                    tya   
2154 3B7E 29 0F 0F              and   #$0F0F
2155 3B81 48                    pha   
2156 3B82 A7 2D                 lda   [<work]
2157 3B84 29 F0 F0              and   #$F0F0
2158 3B87 03 01                 ora   1,s
2159 3B89 83 01                 sta   1,s
2160 3B8B              ;
2161 3B8B A0 49 00              ldy   #GraphicsMode-1
2162 3B8E B7 41                 lda   [<data],y
2163 3B90 AA                    tax                            Keep mode in X.
2164 3B91 10 16                 bpl   mode320                  What's the mode, 320 or 640?
2165 3B93              ;
2166 3B93              *** 8-Dec-91 DAL -- use 32-byte patt in 640 mode if ArcRot bit 15 is set!
2167 3B93 48                    pha   
2168 3B94 A2 04 B1 22           _GetArcRot 
2169 3B9B A2 00 00              ldx   #0                       ;anticipate arcrot640, handle like 320
2170 3B9E 68                    pla   
2171 3B9F 30 08                 bmi   mode320
2172 3BA1 A2 00 80              ldx   #$8000                   ;plain 640 mode
2173 3BA4              *** end 8-Dec-91
2174 3BA4 A0 0E 00              ldy   #14                      640 mode index.
2175 3BA7 80 03                 bra   lop801
2176 3BA9              ;
2177 3BA9 A0 1E 00     mode320  ldy   #30                      320 mode index.
2178 3BAC              ;
2179 3BAC 20 CF 3E     lop801   jsr   set1
2180 3BAF 8A                    txa   
2181 3BB0 30 03                 bmi   skip800
2182 3BB2 20 CF 3E              jsr   set1
2183 3BB5              ;
2184 3BB5 20 D3 3E     skip800  jsr   set2
2185 3BB8 30 08                 bmi   done800
2186 3BBA 8A                    txa   
2187 3BBB 30 EF                 bmi   lop801
2188 3BBD 20 D3 3E              jsr   set2
2189 3BC0 10 EA                 bpl   lop801
2190 3BC2              ;
2191 3BC2              ;
2192 3BC2 68           done800  pla   
2193 3BC3 68                    pla   
2194 3BC4              ;
2195 3BC4              ;
2196 3BC4 A4 2D        exit800  ldy   <work                    Return pointer to pattern.
2197 3BC6 A6 2F                 ldx   <work+2
2198 3BC8              ;
2199 3BC8 68                    pla                            Restore work.
2200 3BC9 85 2D                 sta   <work
2201 3BCB 68                    pla   
2202 3BCC 85 2F                 sta   <work+2
2203 3BCE
2204 3BCE 60                    rts   
2205 3BCF              ;
2206 3BCF              ;
2207 3BCF A3 05        set1     lda   5,s
2208 3BD1 80 02                 bra   enter2
2209 3BD3              ;
2210 3BD3              ;
2211 3BD3 A3 03        set2     lda   3,s
2212 3BD5 97 2D        enter2   sta   [<work],y
2213 3BD7 88                    dey   
2214 3BD8 88                    dey   
2215 3BD9
2216 3BD9 60                    rts   
2217 3BDA
2218 3BDA              ;====================================================================
2219 3BDA              ;
2220 3BDA              ;   IN:    a = color in low nibble.
2221 3BDA              ;
2222 3BDA              ;  OUT:    a = color in all four nibbles.
2223 3BDA              ;
2224 3BDA              ;====================================================================
2225 3BDA 29 0F 00     getcolor and   #$000F
2226 3BDD 48                    pha   
2227 3BDE 0A                    asl   a
2228 3BDF 0A                    asl   a
2229 3BE0 0A                    asl   a
2230 3BE1 0A                    asl   a
2231 3BE2 03 01                 ora   1,s
2232 3BE4 83 01                 sta   1,s
2233 3BE6 EB                    xba   
2234 3BE7 03 01                 ora   1,s
2235 3BE9 FA                    plx   
2236 3BEA
2237 3BEA 60                    rts   
2238 3BEB              ;
2239 3BEB                       ENDP 
2240 3BEB
2241 3BEB
2242 3BEB
2243 3BEB                       END   
